set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4214',
      '30403324',
      '32040342',
      '43211310',
      NULL,
      '44022342',
      '32243140',
      '33003244',
      NULL,
      NULL,
      '31011200',
      '02141043',
      '12133140',
      '02144314',
      '03032211',
      '21142330',
      '00233112',
      '20201233',
      '14342024',
      '00001411',
      '43303213',
      '14424341',
      '34210304',
      '20231420',
      NULL,
      '04143121',
      '40220324',
      '22143011',
      '20304324',
      '34320330',
      '02124134',
      '03014044',
      '32413314',
      '41440241',
      '44342414',
      '42411311',
      NULL,
      '20444212',
      '44313430',
      '02132411',
      '12201304',
      '24220322',
      NULL,
      '13014203',
      '24112040',
      '',
      '',
      NULL,
      NULL,
      '0322404',
      NULL,
      0,
      3,
      NULL,
      '111343',
      1.314165,
      ' 0-20-1978',
      NULL,
      24.534470,
      NULL,
      1.191570,
      11.681698,
      9.631083,
      4.433093,
      NULL,
      9,
      11,
      6.116259,
      10,
      12.027431,
      24.898295,
      0.036172,
      NULL,
      NULL,
      7.743909,
      2.339560,
      7.821188,
      NULL,
      41.928730,
      NULL,
      31,
      7,
      NULL,
      44.249379,
      15.867912,
      18.619738,
      68.139889,
      96.005527,
      NULL,
      ' 2-21-1974',
      NULL,
      24.230719,
      NULL,
      19,
      88,
      NULL,
      NULL,
      1.578195,
      7,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.468971,
      NULL,
      6,
      0.562392,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-17-1995',
      127.604035,
      82,
      47.904458,
      10.243749,
      86.766066,
      87.359699,
      50.138505,
      43,
      124,
      NULL,
      79.470161,
      9,
      NULL,
      10,
      NULL,
      19.942510,
      NULL,
      17.153922,
      1,
      7.696613,
      '11-14-1991',
      NULL,
      5.217346,
      ' 6-18-1985',
      NULL,
      4,
      9,
      13.050049,
      12.168318,
      3.488209,
      NULL,
      2,
      NULL,
      10.796350,
      11,
      1,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 3-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36.574743,
      35,
      NULL,
      ' 8-29-1995',
      3,
      44,
      ' 8-27-1982',
      0.391187,
      14.017179,
      NULL,
      22.658851,
      '11-13-1979',
      5.986106,
      0,
      47.991803,
      ' 1- 1-1979',
      NULL,
      NULL,
      NULL,
      49,
      20.135832,
      1.137908,
      5,
      NULL,
      44.589572,
      7,
      NULL,
      50.729659,
      35.116027,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0.570952,
      0.943729,
      28.203938,
      1,
      NULL,
      132.215640,
      2,
      10,
      91,
      109,
      14,
      31.376736,
      1.156101,
      101,
      0.701884,
      NULL,
      0,
      0.934930,
      0.530235,
      NULL,
      54.344471,
      100,
      42,
      17,
      8.096022,
      87.310962,
      1,
      1.744618,
      3.971149,
      0.559747,
      2.364492,
      0,
      16.047530,
      0.238461,
      39,
      1.828790,
      NULL,
      1.884588,
      2.301899,
      109.337430,
      11.863434,
      NULL,
      8,
      NULL,
      98,
      NULL,
      NULL,
      5.420759,
      9,
      2,
      12,
      1.684664,
      2.566787,
      9.728742,
      NULL,
      68.325442,
      ' 3-20-1986',
      ' 0-14-1985',
      ' 6- 1-2002',
      '10-24-1982',
      ' 9-15-1997',
      ' 2-11-1988',
      ' 6-13-1981',
      NULL);
commit;
end;
/


