set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3220',
      '13432342',
      NULL,
      '40103100',
      '31034014',
      NULL,
      '02341404',
      '22041314',
      NULL,
      '11133204',
      '23102302',
      '40444121',
      '03001011',
      '03112444',
      '23120402',
      NULL,
      '33300401',
      '03433021',
      NULL,
      NULL,
      '40043401',
      NULL,
      '10001324',
      '20444010',
      NULL,
      '02244420',
      '23114244',
      NULL,
      '02302141',
      '12131101',
      NULL,
      '23331043',
      '02203104',
      '10030142',
      '24003424',
      '23314422',
      '13123143',
      '13242103',
      '43030101',
      '10214144',
      '41002220',
      '00202303',
      '30033040',
      '01103113',
      '41302204',
      '431',
      NULL,
      9,
      19,
      '3300312',
      2.395690,
      169,
      1,
      NULL,
      '433040',
      2,
      ' 6- 3-1975',
      NULL,
      89.651149,
      55,
      17,
      9,
      4,
      7.293292,
      40.020772,
      8,
      19.958378,
      15,
      1.080318,
      NULL,
      2.368525,
      NULL,
      30.718211,
      18,
      NULL,
      NULL,
      5,
      12.532887,
      26,
      14,
      73.384866,
      NULL,
      0,
      65,
      111.285646,
      37.662765,
      143,
      28.503337,
      155,
      ' 0- 1-1984',
      26.656471,
      45.815333,
      12,
      23.946158,
      61.023176,
      51,
      ' 2-17-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      88,
      1.652183,
      0,
      NULL,
      NULL,
      4,
      ' 0- 0-1997',
      0.306130,
      0.523654,
      32,
      1,
      NULL,
      48.490182,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 4-1989',
      82,
      91,
      24,
      0,
      70.092436,
      22,
      44,
      NULL,
      23.098185,
      11.780666,
      58.513776,
      NULL,
      NULL,
      9,
      21,
      10.714131,
      45.057380,
      39.894653,
      57,
      9,
      ' 9-26-1984',
      NULL,
      19,
      ' 4- 0-2000',
      1,
      NULL,
      5,
      7,
      NULL,
      NULL,
      1.074095,
      9.138620,
      NULL,
      19,
      1.040720,
      2.550280,
      5,
      17.388003,
      0,
      0.443318,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 9-21-1989',
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      22.837956,
      ' 5- 2-1999',
      6.127191,
      2.031099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      19.497008,
      NULL,
      9,
      1,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      12.176678,
      16.470026,
      3,
      ' 3-14-1983',
      15,
      0,
      48,
      ' 8-28-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


