set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      '1',
      '0',
      '4',
      NULL,
      '2',
      NULL,
      '3',
      '4',
      '4',
      '0',
      '0',
      '0',
      '0',
      '0',
      '1',
      '4',
      '2',
      '0',
      '3',
      '1',
      '2',
      NULL,
      '',
      '0',
      '',
      NULL,
      NULL,
      '3',
      NULL,
      '4',
      '',
      '',
      '2',
      '0',
      '4',
      '1',
      NULL,
      '3',
      '1',
      '0',
      '2',
      '1',
      '2',
      '021',
      '10423304',
      NULL,
      4.541968,
      '2304312',
      1.283926,
      238.771768,
      0,
      NULL,
      '132004',
      NULL,
      ' 8-16-1995',
      ' 8- 6-1998',
      NULL,
      74,
      NULL,
      1.646088,
      7.192231,
      7.790604,
      19,
      2,
      2,
      10.305808,
      2,
      5,
      15,
      0,
      7.087893,
      14,
      NULL,
      7.272128,
      NULL,
      NULL,
      24,
      NULL,
      19,
      5,
      1,
      39.993521,
      51,
      58.506346,
      1,
      NULL,
      88.715293,
      NULL,
      26,
      16.257645,
      NULL,
      2,
      NULL,
      114.398515,
      ' 9- 1-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      19.493831,
      17.754596,
      NULL,
      8.463557,
      NULL,
      ' 7-17-1986',
      3.332002,
      1.363254,
      16,
      0,
      NULL,
      54,
      1,
      5,
      48,
      NULL,
      NULL,
      NULL,
      ' 1- 0-1983',
      70.054252,
      56.823022,
      7.478042,
      NULL,
      49.122596,
      70.893333,
      NULL,
      NULL,
      58,
      NULL,
      88.551145,
      75.513157,
      ' 6- 1-1977',
      23,
      12,
      NULL,
      40.010987,
      41,
      NULL,
      NULL,
      ' 9-21-1981',
      5.833367,
      5.000975,
      ' 4-23-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59,
      2,
      ' 4-15-1984',
      NULL,
      NULL,
      NULL,
      30.569713,
      NULL,
      21.134754,
      '10-22-1978',
      14.624801,
      10.598559,
      ' 9-29-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      23.650457,
      ' 8-16-1982',
      13.156192,
      20.676992,
      38.038337,
      ' 7- 0-1981',
      0,
      24,
      '11- 2-1980',
      15,
      56,
      19.912712,
      47,
      ' 6- 9-2002',
      NULL,
      1.704067,
      129.543345,
      ' 3- 2-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


