set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '4',
      '3',
      '1',
      '3',
      '1',
      '2',
      '3',
      '4',
      '4',
      '0',
      '4',
      '3',
      '2',
      NULL,
      '1',
      '0',
      NULL,
      '2',
      NULL,
      '3',
      '0',
      '0',
      '',
      '4',
      NULL,
      '2',
      '4',
      '3',
      '1',
      NULL,
      '',
      '',
      '3',
      '3',
      '3',
      '4',
      NULL,
      '4',
      NULL,
      '0',
      NULL,
      '2',
      '3',
      '242',
      NULL,
      64,
      81,
      '2224404',
      2.561550,
      186,
      2,
      1,
      '421231',
      6.035329,
      ' 1-10-2001',
      ' 5-27-2001',
      100,
      40,
      13.797521,
      8.784379,
      NULL,
      8,
      NULL,
      NULL,
      19,
      4,
      13.328495,
      12,
      9.587990,
      8,
      15.304181,
      NULL,
      0.878613,
      6,
      8.709694,
      NULL,
      3.933351,
      NULL,
      63,
      7.617857,
      NULL,
      30,
      147,
      50,
      57,
      96,
      66,
      '11-18-2001',
      31.582092,
      25,
      12.270578,
      11.746788,
      166,
      20.916832,
      '10-13-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.167708,
      3,
      2,
      20.503069,
      2.841246,
      ' 4-11-1975',
      NULL,
      0,
      NULL,
      1,
      1.155099,
      24,
      1.203388,
      1.033167,
      3,
      NULL,
      NULL,
      NULL,
      '11-15-1994',
      38,
      105,
      26,
      94.285620,
      28,
      42.477468,
      NULL,
      87,
      NULL,
      83,
      19,
      18.660387,
      NULL,
      10.739852,
      8.649387,
      8,
      30,
      24,
      9,
      0,
      '10- 2-1986',
      10.974502,
      11.742192,
      '10-15-1977',
      NULL,
      2,
      3,
      14.322653,
      20.512773,
      2.825844,
      1,
      2.082947,
      2.701199,
      51.446949,
      0,
      NULL,
      6.549533,
      17,
      3.103009,
      NULL,
      NULL,
      1.910817,
      ' 6-26-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      2.732788,
      42.842980,
      ' 4-25-1988',
      NULL,
      NULL,
      NULL,
      36,
      ' 7-18-2000',
      NULL,
      ' 5-19-1981',
      10.722918,
      17.465530,
      ' 7-25-1974',
      48.014627,
      69,
      ' 4-19-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      ' 0-13-1986',
      24.029458,
      5.097036,
      2,
      '11-18-2003',
      5.644165,
      NULL,
      ' 5-17-2003',
      10.558083,
      48,
      12,
      30,
      '11-28-2000',
      8,
      NULL,
      104.488925,
      ' 3- 1-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


