set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6409843';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      '0',
      '3',
      '4',
      '4',
      '1',
      '3',
      '3',
      '2',
      '0',
      NULL,
      '3',
      '2',
      '0',
      '2',
      '3',
      '3',
      NULL,
      NULL,
      '1',
      '3',
      '2',
      '2',
      '',
      '3',
      '',
      '3',
      '4',
      '1',
      '3',
      '4',
      '',
      NULL,
      '2',
      '4',
      '2',
      '3',
      '2',
      '2',
      NULL,
      NULL,
      '2',
      '1',
      '2',
      '343',
      '11330040',
      1.190240,
      NULL,
      '2310233',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      ' 4- 3-1993',
      ' 3-22-1983',
      21,
      35,
      NULL,
      8,
      7,
      17,
      NULL,
      5,
      17,
      0,
      3.959981,
      16,
      7.602334,
      10,
      6.388769,
      6.572582,
      1,
      11.441946,
      24.424579,
      23.713781,
      NULL,
      13.348147,
      NULL,
      3.012792,
      0.207219,
      88.787557,
      NULL,
      61,
      150.579955,
      53.549052,
      4.798654,
      ' 4-26-1986',
      NULL,
      25.130483,
      26.339563,
      36,
      170.432149,
      13.483936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53.880506,
      11.116128,
      5,
      7.332303,
      4,
      3.558180,
      ' 4-26-1985',
      0.425197,
      1.575681,
      26.842856,
      0,
      NULL,
      26,
      6.518805,
      1,
      62,
      NULL,
      NULL,
      NULL,
      ' 5-28-1975',
      64,
      81,
      NULL,
      NULL,
      7.246296,
      NULL,
      NULL,
      108.074011,
      102.773243,
      NULL,
      68.080804,
      87.975192,
      '10-29-2001',
      6,
      27,
      18.363157,
      NULL,
      84,
      42.946419,
      8.218261,
      ' 1-26-1998',
      6.396791,
      9.772089,
      NULL,
      5,
      0.057482,
      21,
      18.765743,
      NULL,
      5,
      NULL,
      20.469745,
      0,
      65.623520,
      0,
      NULL,
      13,
      NULL,
      0.725056,
      0.044497,
      5.923264,
      NULL,
      ' 5-24-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      55.458742,
      2.003796,
      ' 2-29-1974',
      NULL,
      NULL,
      NULL,
      45.832211,
      ' 9-11-1996',
      NULL,
      NULL,
      8,
      5.873291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      30,
      9.625987,
      ' 2-15-1978',
      1.222358,
      2.489902,
      ' 3-25-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


