set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9420564';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1143',
      '10121222',
      '11314200',
      '02413344',
      '13423243',
      '40010310',
      '34330242',
      '34402034',
      NULL,
      '24113314',
      '42000441',
      NULL,
      '31220222',
      '13013240',
      '30022320',
      '32020421',
      NULL,
      '42143444',
      '00024010',
      '04300344',
      '21041140',
      '44333130',
      '42204414',
      '03101404',
      NULL,
      '40422204',
      '03441113',
      '30432403',
      '41200100',
      '31401341',
      '00241443',
      '11342040',
      '04043313',
      '03123122',
      '21341130',
      '43432342',
      '03113234',
      NULL,
      NULL,
      '34143302',
      '10324241',
      '12014244',
      NULL,
      '34401300',
      '03401303',
      '441',
      '12',
      NULL,
      NULL,
      '4140124',
      3.796919,
      0,
      1,
      NULL,
      '313332',
      4.474933,
      NULL,
      ' 4- 0-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      15.183638,
      NULL,
      43.943493,
      NULL,
      5,
      2,
      NULL,
      7,
      NULL,
      3,
      21.638884,
      0,
      NULL,
      7.299889,
      16.380827,
      10,
      NULL,
      NULL,
      3.599967,
      7,
      1.811573,
      56,
      26.603106,
      47,
      54,
      81.199678,
      94,
      ' 5- 4-1983',
      18.285200,
      25.132755,
      11.578941,
      1,
      196,
      NULL,
      '11-24-1982',
      0.909530,
      2.172734,
      1.341870,
      7,
      NULL,
      11.889801,
      3.211134,
      0,
      0.292556,
      NULL,
      NULL,
      0.979115,
      1,
      8.560020,
      NULL,
      1,
      11,
      1,
      1,
      4.291473,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-11-1992',
      27,
      4,
      25.894561,
      11,
      NULL,
      5,
      ' 3-18-1989',
      1,
      NULL,
      48,
      1,
      3,
      26.687697,
      1.947026,
      5.013416,
      0.181006,
      NULL,
      NULL,
      NULL,
      '11-23-1983',
      91,
      79,
      NULL,
      NULL,
      NULL,
      99.268576,
      86,
      65.591081,
      NULL,
      51,
      NULL,
      NULL,
      NULL,
      8.528384,
      1,
      4.410017,
      5.930869,
      32.351495,
      0.831424,
      3,
      ' 5-22-1985',
      11,
      5.646121,
      NULL,
      1.067938,
      11.758384,
      16.057431,
      16.168922,
      17,
      2,
      1.385421,
      NULL,
      1,
      73.647650,
      1.615086,
      NULL,
      12,
      1.332957,
      NULL,
      3,
      1,
      0.904612,
      ' 5-25-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      125.137260,
      1,
      ' 0-14-2002',
      NULL,
      NULL,
      NULL,
      10,
      ' 0- 3-1981',
      34,
      ' 7- 5-1978',
      14,
      13,
      ' 5- 6-1996',
      120,
      23.322886,
      ' 9- 8-2003',
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      20,
      NULL,
      NULL,
      3,
      20.227288,
      NULL,
      1.420139,
      48,
      NULL,
      NULL,
      40,
      3,
      84.536911,
      NULL,
      26,
      0,
      94.042945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


