set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23140334',
      '11400143',
      '11112202',
      '40010334',
      '21002333',
      '11104203',
      '14113302',
      '01404310',
      '32214124',
      '33240311',
      '42244441',
      '03104103',
      '30422024',
      '34424322',
      '41321122',
      '44320414',
      NULL,
      '12223414',
      '10131213',
      '02421304',
      '40210403',
      '30123022',
      '13010120',
      '44032133',
      '24004142',
      '33044103',
      '00311442',
      '02302332',
      NULL,
      NULL,
      '40422340',
      '11312410',
      '01121131',
      '22241122',
      '11101000',
      '13324322',
      '20424224',
      NULL,
      '01331323',
      '11302314',
      NULL,
      '20204003',
      NULL,
      '23440132',
      '212',
      '32',
      NULL,
      NULL,
      NULL,
      2.464904,
      NULL,
      3,
      NULL,
      '303114',
      3,
      NULL,
      ' 3-20-1990',
      58,
      NULL,
      3,
      16,
      11.942669,
      6.410853,
      10.530235,
      15,
      NULL,
      16,
      4.336657,
      22.820877,
      1.026804,
      11,
      NULL,
      2,
      3.492914,
      0.034444,
      97,
      24,
      21.345491,
      2,
      46.694455,
      18,
      2.044057,
      82,
      NULL,
      14.803228,
      3,
      243,
      174.090888,
      ' 3-24-1974',
      59.329760,
      44.203342,
      16,
      22.896217,
      99.225292,
      188,
      '11-11-1980',
      0.068360,
      1.632858,
      0.874133,
      0.012691,
      1.840379,
      1.360420,
      1,
      1.651725,
      1.226108,
      1,
      0.294240,
      1,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-18-1989',
      29,
      0,
      10,
      1.393883,
      9,
      0.683140,
      '11-27-1989',
      1,
      1,
      NULL,
      1.727621,
      3,
      NULL,
      0.347823,
      0,
      110,
      0.054935,
      1.628183,
      215,
      ' 3-15-1991',
      9,
      49,
      21,
      98,
      123,
      NULL,
      120,
      71.346572,
      48,
      86,
      87,
      65.345668,
      ' 0- 4-1993',
      1.354476,
      37,
      17.929036,
      56,
      70,
      173.074673,
      13,
      ' 3-22-1988',
      NULL,
      0,
      ' 4-12-1984',
      6.125399,
      26.061449,
      3,
      16,
      NULL,
      3,
      1,
      NULL,
      0.712072,
      38.145994,
      1.041053,
      1.181955,
      NULL,
      1,
      0.473244,
      1,
      1,
      NULL,
      ' 8-23-1993',
      5,
      NULL,
      7,
      ' 0-13-1993',
      NULL,
      7,
      ' 5- 8-1985',
      1.499000,
      3.760841,
      ' 8-29-1981',
      33,
      NULL,
      38,
      ' 4- 9-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      93.889176,
      ' 9- 0-1985',
      1.581271,
      8.801804,
      ' 8-12-1984',
      NULL,
      3.290463,
      '10- 3-1991',
      1,
      0,
      21.798179,
      NULL,
      33.685677,
      47.076842,
      49.978928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.847025);
commit;
end;
/


