set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514057';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0301',
      NULL,
      NULL,
      '41331400',
      '00143211',
      '44441314',
      '23444043',
      '20400004',
      '32331034',
      '42122334',
      '14031144',
      '00114103',
      '20442331',
      '43230330',
      '23021202',
      '21010103',
      '02340041',
      '21001341',
      '10433024',
      '31340120',
      '01231330',
      '14311020',
      '21122403',
      '20310224',
      '23304310',
      '44442144',
      '33344222',
      NULL,
      '32234142',
      '14210202',
      '34442310',
      '30322343',
      '00031414',
      '01212001',
      NULL,
      '04420101',
      '20200311',
      NULL,
      NULL,
      '22321131',
      '34341030',
      '01112031',
      '00141411',
      '34102443',
      '00003211',
      '144',
      '14',
      NULL,
      NULL,
      '0312233',
      1.224425,
      0.447048,
      NULL,
      NULL,
      '121104',
      4.818325,
      ' 0- 6-2000',
      ' 3-29-1995',
      19,
      NULL,
      47.047614,
      20,
      24,
      3,
      3,
      2.103511,
      1.701459,
      14.857246,
      1.723610,
      11.039682,
      15,
      26.753508,
      30,
      4.153943,
      8.740191,
      11.068051,
      85.054157,
      31,
      2.675296,
      19,
      NULL,
      21,
      NULL,
      83,
      125,
      20,
      129,
      12,
      239.582076,
      ' 5-14-1993',
      51,
      34,
      14,
      NULL,
      167.549314,
      13,
      NULL,
      1,
      1.297956,
      1.549416,
      0.230586,
      0,
      0.443125,
      NULL,
      1.946972,
      0,
      0.244373,
      1,
      1.364737,
      NULL,
      0.387078,
      0.652165,
      1.322272,
      0.419602,
      1.603675,
      1.485240,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      11.164562,
      NULL,
      NULL,
      NULL,
      6,
      ' 9- 4-1975',
      0,
      1.483829,
      25.763673,
      1.157573,
      1.585093,
      NULL,
      1.091491,
      NULL,
      92,
      NULL,
      NULL,
      NULL,
      ' 9- 3-1980',
      104,
      15.455257,
      15.551504,
      22,
      NULL,
      48.491418,
      113,
      NULL,
      0,
      108,
      45.953294,
      33,
      ' 7- 0-1979',
      22.319809,
      8.610878,
      22,
      99,
      NULL,
      7,
      9,
      ' 1- 2-2000',
      31.406511,
      NULL,
      ' 3-29-1974',
      3.617892,
      13,
      21,
      17.406192,
      8,
      NULL,
      0.333791,
      NULL,
      NULL,
      62,
      0.521491,
      2,
      11,
      11.703188,
      0.464633,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      246,
      0.136456,
      ' 2- 9-1985',
      NULL,
      NULL,
      NULL,
      16,
      ' 2- 0-1978',
      19.514523,
      '10-29-2001',
      6.354563,
      2.279864,
      NULL,
      20,
      NULL,
      ' 3-24-1997',
      8.518401,
      7.214681,
      '11-10-1978',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      20.255879,
      ' 4-25-2001',
      NULL,
      44,
      NULL,
      ' 6- 6-1998',
      0.008092,
      NULL,
      ' 0-28-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


