set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8127344';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2041',
      '00440233',
      '22020202',
      '42003301',
      '01310103',
      '00122120',
      '41024042',
      '42044213',
      '10313222',
      NULL,
      '23233314',
      '14302243',
      '04041031',
      '33204003',
      '10320240',
      '14304302',
      '01224042',
      NULL,
      '20120122',
      '33421242',
      '02403403',
      NULL,
      '14024131',
      '24143202',
      NULL,
      '00130224',
      '22431303',
      '33240143',
      '22204133',
      NULL,
      '10220110',
      '34341322',
      '43221122',
      NULL,
      '40340024',
      '10401422',
      NULL,
      '04423343',
      '10032204',
      NULL,
      '23301343',
      '40004413',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      '241433',
      2.442841,
      NULL,
      '10- 2-1980',
      52.120347,
      NULL,
      NULL,
      21,
      NULL,
      29.449204,
      75.783154,
      0.573498,
      33.232899,
      15,
      17,
      15,
      0.716913,
      1,
      2.185817,
      25.065437,
      19,
      7.067840,
      NULL,
      NULL,
      NULL,
      1.252011,
      164.423441,
      5.585100,
      NULL,
      14,
      NULL,
      42,
      36,
      115,
      232.422490,
      ' 9- 0-2003',
      NULL,
      NULL,
      15.260773,
      19,
      165,
      170.646889,
      '10-22-1986',
      0.385792,
      0.491586,
      NULL,
      0.938276,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.793647,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.666607,
      56.383762,
      19.956193,
      NULL,
      123.846236,
      59.114525,
      31,
      NULL,
      4,
      101.754971,
      70.455077,
      11,
      ' 4- 0-1982',
      11,
      NULL,
      13,
      90.920546,
      35,
      0.475888,
      4,
      ' 9-18-1997',
      0,
      NULL,
      ' 5- 5-1996',
      10.593864,
      16.590330,
      14.105333,
      19.571891,
      NULL,
      20,
      NULL,
      21.732296,
      NULL,
      NULL,
      NULL,
      5,
      22.403304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-17-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      49.750863,
      NULL,
      NULL,
      55,
      ' 3-21-1980',
      6,
      NULL,
      14,
      23.330040,
      ' 4-24-1988',
      23.541567,
      0.886035,
      30,
      ' 2- 7-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      21,
      2,
      2,
      5,
      NULL,
      7.667047,
      NULL,
      1,
      NULL,
      46.653862,
      0,
      NULL,
      38,
      0.032225,
      0,
      95.561787,
      NULL,
      3.134216,
      NULL,
      NULL,
      15.058096,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.532923,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      25.216212,
      NULL,
      NULL,
      NULL,
      1,
      27.358275,
      0.270309,
      1,
      0.562940,
      60,
      1.577876,
      NULL,
      1.524898,
      NULL,
      0.760611,
      1,
      NULL,
      4,
      23.771147,
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      4.241957,
      0.054701,
      NULL,
      1.494796,
      1,
      NULL,
      1,
      1,
      NULL,
      '11-21-1993',
      ' 4- 1-1991',
      ' 0- 3-1974',
      ' 8- 4-1975',
      ' 2- 7-1983',
      '10-21-1994',
      NULL,
      NULL);
commit;
end;
/


