set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9518819';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10300000',
      '24313034',
      NULL,
      '13233242',
      NULL,
      '20134434',
      NULL,
      '40431421',
      '13343212',
      NULL,
      '03033201',
      NULL,
      '33314340',
      '21433211',
      '23324312',
      NULL,
      NULL,
      '12220011',
      '44420243',
      NULL,
      '00010303',
      '32414031',
      '00023223',
      NULL,
      '34312222',
      NULL,
      NULL,
      '41414024',
      '14240013',
      '41321440',
      '02044130',
      '10310011',
      '23004243',
      NULL,
      NULL,
      '33444420',
      '30321102',
      NULL,
      '42001042',
      '10243143',
      '02324231',
      '40140223',
      '03212402',
      '14340004',
      '441',
      '10',
      NULL,
      NULL,
      '0133034',
      0,
      0,
      1,
      NULL,
      '413401',
      3.190201,
      NULL,
      ' 5-11-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      48,
      15,
      31,
      123,
      105.031218,
      '11-17-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      40.785345,
      41,
      11.697770,
      19.656628,
      NULL,
      '10-13-1985',
      NULL,
      1,
      NULL,
      0.491482,
      NULL,
      18.604709,
      NULL,
      NULL,
      38,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      NULL,
      50,
      41,
      11,
      32,
      14.118364,
      22.222551,
      17.120404,
      14,
      27.530627,
      26.600628,
      ' 2-27-1974',
      NULL,
      6,
      5.812993,
      29,
      17.845680,
      80,
      NULL,
      ' 2- 1-1995',
      28.391095,
      2.665656,
      NULL,
      4.512117,
      1,
      4.904461,
      15.131930,
      1,
      11.044143,
      NULL,
      NULL,
      0.809313,
      66,
      0.266112,
      1.085619,
      13.164030,
      9,
      3.798733,
      0.497730,
      1.950678,
      NULL,
      ' 8- 3-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      64.437294,
      4,
      '10-29-1994',
      NULL,
      NULL,
      NULL,
      38.705435,
      ' 4- 5-1990',
      21.108509,
      ' 0-16-1979',
      11.544421,
      10.749601,
      '10-18-1993',
      12,
      72,
      ' 6-27-1997',
      0,
      1.570681,
      ' 9- 5-2000',
      NULL,
      NULL,
      NULL,
      1,
      3,
      13.958477,
      '11-16-2002',
      56.723032,
      31,
      48,
      NULL,
      1,
      67,
      NULL,
      8.666620,
      0,
      17,
      4,
      NULL,
      28,
      NULL,
      58.778583,
      ' 5- 6-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


