set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6225292';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4301',
      NULL,
      NULL,
      NULL,
      '24122213',
      '43142421',
      '23124021',
      '30401320',
      '21334141',
      '30142123',
      '44231343',
      NULL,
      '20420441',
      '42244114',
      '41140320',
      '31213000',
      '21212303',
      '30200414',
      NULL,
      '44102444',
      '13313043',
      '22321422',
      '33334141',
      NULL,
      '21310033',
      NULL,
      '23333323',
      '34113234',
      '34242002',
      '31412200',
      '44040114',
      '30343010',
      '00213240',
      '42322040',
      '14433431',
      '03144112',
      '03010213',
      '24223233',
      '23324313',
      '10413400',
      '30033004',
      '10120130',
      NULL,
      '43113040',
      '41334143',
      '',
      '',
      NULL,
      NULL,
      '1222011',
      0,
      NULL,
      2,
      NULL,
      '110303',
      0.283362,
      '10-16-1998',
      ' 3-17-1983',
      16,
      NULL,
      NULL,
      8.834832,
      NULL,
      13,
      NULL,
      4.745531,
      NULL,
      8.281260,
      NULL,
      11.457324,
      NULL,
      17.339098,
      NULL,
      4.948535,
      NULL,
      NULL,
      NULL,
      1.186006,
      NULL,
      11,
      NULL,
      4,
      NULL,
      NULL,
      48.031929,
      NULL,
      59,
      NULL,
      65,
      ' 3-27-1974',
      NULL,
      7.415406,
      5,
      6,
      8.810471,
      4,
      ' 7-17-1993',
      3.939291,
      0.682417,
      5.468241,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.694790,
      6.844901,
      3.937390,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 1-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      128,
      111.774140,
      56.976427,
      NULL,
      NULL,
      137,
      44,
      NULL,
      36.039425,
      87.362371,
      3,
      NULL,
      4.457990,
      9.963860,
      2.444750,
      NULL,
      8,
      16,
      9,
      ' 3-11-1986',
      7,
      1.673845,
      NULL,
      NULL,
      4,
      8,
      4,
      6,
      NULL,
      NULL,
      1.093820,
      NULL,
      11.239715,
      1,
      0.794912,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      2,
      0.422620,
      ' 7- 6-2000',
      35,
      523.316037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53.686476,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.257895,
      NULL,
      4,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      105,
      1.599548,
      1,
      28.562564,
      0,
      1,
      46,
      1,
      NULL,
      76,
      58.811349,
      31,
      7.905651,
      3,
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.922861,
      5,
      2,
      53,
      6.485523,
      0.885092,
      0.982006,
      NULL,
      0,
      1.913427,
      0.012693,
      3.272220,
      0.439544,
      66.068880,
      NULL,
      33,
      0.799441,
      0,
      43,
      3.850686,
      1.352990,
      17.958255,
      32.491297,
      46.417399,
      1.816192,
      21.427363,
      NULL,
      22,
      10.937573,
      4,
      1,
      0.179851,
      1,
      1.344707,
      61.379320,
      NULL,
      ' 2- 9-1990',
      '11-29-2001',
      ' 4- 4-1994',
      '10-26-1975',
      ' 7- 3-1986',
      ' 3-12-1991',
      NULL);
commit;
end;
/


