set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8214967';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2242',
      NULL,
      '03302023',
      '41441242',
      '40003142',
      '12324104',
      '24331024',
      '43130444',
      NULL,
      '01314430',
      '14411004',
      '41122244',
      '20424033',
      NULL,
      '01342013',
      '23211114',
      '41410303',
      '34344100',
      NULL,
      NULL,
      '11303342',
      '30034210',
      NULL,
      '42130243',
      '33034214',
      '00243411',
      '14330320',
      '12224343',
      '22231014',
      '11234040',
      '04004404',
      '33242211',
      '00001433',
      '03434011',
      '12101102',
      '43010311',
      '22304122',
      '11100321',
      '00401100',
      '44101330',
      '30310304',
      '13344114',
      NULL,
      '01303232',
      '14321122',
      '303',
      '14',
      NULL,
      NULL,
      '3111343',
      1.209462,
      NULL,
      NULL,
      NULL,
      '133403',
      5.399930,
      ' 3-22-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      25,
      19.785024,
      18,
      NULL,
      1.115903,
      14,
      17,
      NULL,
      36.585808,
      2.642301,
      15.386755,
      NULL,
      25,
      23,
      73.585881,
      NULL,
      3,
      1,
      98,
      NULL,
      0.398236,
      NULL,
      74.046481,
      102,
      NULL,
      24.184324,
      185,
      ' 8-10-1975',
      35,
      7.206957,
      16.354652,
      7.353268,
      33,
      176,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3.046903,
      2,
      1.028739,
      0,
      1,
      2.524816,
      1.756526,
      0.566441,
      5,
      0.044931,
      0,
      0.108047,
      0,
      NULL,
      1.161523,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 0-1974',
      67.953212,
      34,
      NULL,
      21.767526,
      8.551626,
      NULL,
      ' 2-18-1974',
      NULL,
      0,
      48,
      NULL,
      6.713776,
      38,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 4-2002',
      66.163635,
      32,
      113,
      113.658370,
      NULL,
      17.033916,
      108.981242,
      79,
      53.675741,
      107,
      14.777709,
      105,
      ' 3- 8-1999',
      NULL,
      8.014987,
      3.573677,
      30,
      NULL,
      NULL,
      10.190045,
      ' 0-25-1992',
      20,
      0,
      '11- 4-2001',
      10.531232,
      4.673173,
      3,
      27.585492,
      14,
      10.632555,
      NULL,
      NULL,
      0,
      130.703459,
      NULL,
      5.823268,
      20,
      15,
      NULL,
      0,
      0,
      0.508476,
      ' 2-14-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      147,
      0.969748,
      ' 2-22-1980',
      NULL,
      NULL,
      NULL,
      2.553823,
      '11-14-1990',
      11.095945,
      ' 1-12-1975',
      8.708992,
      NULL,
      '11-26-1999',
      128.349372,
      104,
      ' 3-10-1989',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8,
      ' 0-17-1983',
      NULL,
      52,
      43.375064,
      NULL,
      1,
      13,
      ' 7-24-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


