set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8214967';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4000',
      '11432111',
      '00021210',
      '30014001',
      '22340442',
      '23432322',
      '30044234',
      '30303141',
      '30134130',
      '30303222',
      '13021241',
      '44140233',
      NULL,
      '22423010',
      NULL,
      '13000212',
      '32030402',
      '21232234',
      '33234202',
      '00320200',
      '31430010',
      NULL,
      '24200100',
      '33010040',
      '40121031',
      NULL,
      NULL,
      NULL,
      NULL,
      '13204423',
      NULL,
      '33303144',
      NULL,
      '42431110',
      '12010332',
      '31011002',
      NULL,
      '34144412',
      '10022411',
      NULL,
      '03201414',
      '14134344',
      '42321023',
      NULL,
      '04113120',
      '023',
      NULL,
      NULL,
      NULL,
      NULL,
      2.080331,
      35.017053,
      0,
      NULL,
      '003124',
      0.385097,
      ' 0-18-1975',
      NULL,
      NULL,
      NULL,
      7.996435,
      17.003091,
      27.733034,
      21.532804,
      6.620917,
      NULL,
      22,
      NULL,
      35,
      18,
      NULL,
      24,
      NULL,
      1,
      13.652975,
      12.802677,
      62.610992,
      16.164936,
      59.138992,
      8.392939,
      60.338039,
      23.391692,
      1,
      12,
      NULL,
      104,
      241,
      170,
      89.033300,
      ' 5-18-1975',
      25,
      57.014703,
      24,
      22.008768,
      NULL,
      177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.121889,
      2.082475,
      14.025675,
      0.160267,
      NULL,
      ' 6- 3-1984',
      0.757775,
      1,
      189,
      NULL,
      0.560587,
      43.898376,
      0,
      1,
      65,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      8.152532,
      NULL,
      50.592058,
      1.071493,
      82.698458,
      90,
      NULL,
      NULL,
      30,
      29,
      71.995394,
      ' 8- 7-1984',
      25,
      21.760175,
      NULL,
      69.358653,
      29,
      181,
      1.514421,
      ' 4-15-2000',
      8,
      24.992424,
      ' 5- 4-1981',
      4,
      NULL,
      0.882942,
      9,
      0.644196,
      11.091700,
      1,
      19.653246,
      1,
      126.427547,
      3.911331,
      NULL,
      NULL,
      0,
      NULL,
      0.950352,
      3,
      5,
      ' 0- 9-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      69,
      1,
      '10- 1-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 6-1984',
      40.852344,
      '11-16-1980',
      6.567615,
      14.382359,
      '11- 8-1991',
      90,
      64,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      ' 2-10-1994',
      69.894644,
      24,
      48.573660,
      '11-27-1999',
      NULL,
      15.682101,
      ' 9-18-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


