set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1102',
      '14413101',
      NULL,
      NULL,
      '04220332',
      '12220244',
      '24014240',
      '23341310',
      NULL,
      '14022140',
      '13430334',
      '22421242',
      '04012004',
      '04230230',
      '04003323',
      '34121100',
      '22044410',
      '10443311',
      '02242022',
      '34343024',
      '12104323',
      NULL,
      '40312011',
      '22022414',
      '41404223',
      '24003340',
      '03423410',
      '24132113',
      '01022323',
      '31232304',
      '30242112',
      '02313244',
      '34000314',
      NULL,
      '30434013',
      '41330242',
      '44111033',
      NULL,
      '04112212',
      '32114140',
      '20221003',
      '21312340',
      '44420111',
      '12210331',
      '22013303',
      '312',
      '33',
      NULL,
      NULL,
      '4141031',
      3.734192,
      1.469862,
      NULL,
      NULL,
      '101441',
      4,
      ' 5- 1-2003',
      NULL,
      66.271418,
      NULL,
      NULL,
      4.726267,
      8.991062,
      0.060993,
      NULL,
      4.227623,
      NULL,
      2.897352,
      3,
      1.334661,
      17,
      5,
      17,
      NULL,
      5.741505,
      6.183244,
      NULL,
      11.151696,
      1.363066,
      19.112047,
      38,
      0,
      0.036158,
      17,
      100.912944,
      18.482977,
      19.634735,
      27.688133,
      NULL,
      ' 9-10-1991',
      47.538412,
      8.324232,
      6.101079,
      8,
      NULL,
      112.327027,
      ' 3-27-1984',
      4.195583,
      NULL,
      13,
      6,
      4.285242,
      3.250162,
      NULL,
      3,
      NULL,
      1,
      31,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2.451513,
      3.325069,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-18-1989',
      24,
      22.004432,
      34,
      NULL,
      NULL,
      1,
      ' 9- 6-1992',
      0,
      5.882741,
      44,
      1,
      0,
      88.222764,
      NULL,
      0.728004,
      26.005221,
      NULL,
      NULL,
      NULL,
      '10-12-1985',
      NULL,
      40.394787,
      71,
      59,
      NULL,
      21,
      60.267544,
      NULL,
      88.782119,
      39,
      66,
      69,
      ' 7-18-1996',
      11.402771,
      10,
      NULL,
      NULL,
      31.575471,
      35.088715,
      1,
      NULL,
      7.452347,
      NULL,
      ' 9-22-2002',
      NULL,
      4.997336,
      14,
      16.928688,
      4.552139,
      15,
      0.304658,
      NULL,
      1.382629,
      15.896467,
      1,
      6,
      NULL,
      16,
      NULL,
      2,
      3,
      NULL,
      '10-17-1994',
      1.356039,
      1.237250,
      0,
      ' 9-18-1994',
      138,
      NULL,
      ' 6-29-1982',
      NULL,
      NULL,
      NULL,
      49.352966,
      '10-11-1977',
      18.952360,
      NULL,
      15.095047,
      8.995789,
      ' 0- 0-1978',
      2.660576,
      3.633448,
      NULL,
      0.024714,
      2,
      '10-29-1975',
      15,
      5,
      ' 8-29-1980',
      0,
      2,
      25.124437,
      ' 3-28-1988',
      47,
      25.428577,
      29,
      NULL,
      0,
      154,
      ' 6-13-1982',
      5.348234,
      109,
      16,
      80.340064,
      '11-19-1989',
      18.499381,
      NULL,
      112,
      '10-24-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.857680);
commit;
end;
/


