set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0230',
      '00310433',
      NULL,
      '01343221',
      '23344032',
      '04313210',
      NULL,
      '30141234',
      '01010304',
      '13122132',
      '00334141',
      '02221220',
      '02302320',
      '20101000',
      '23243411',
      '23033102',
      '33214342',
      '33100434',
      '01343024',
      NULL,
      '33133144',
      '04142101',
      '22204031',
      NULL,
      '34014412',
      NULL,
      '40003320',
      '03210421',
      NULL,
      '24001124',
      '31112200',
      '42144143',
      NULL,
      '04221204',
      '30000343',
      '14441332',
      '30122303',
      '21131232',
      '14224130',
      '01142214',
      '20113021',
      '44034144',
      NULL,
      '14202320',
      NULL,
      NULL,
      '41',
      NULL,
      NULL,
      '4341211',
      2,
      7.525730,
      2,
      NULL,
      '341122',
      1.269277,
      ' 6-20-1976',
      NULL,
      1,
      NULL,
      NULL,
      8,
      9,
      4,
      32,
      6,
      NULL,
      NULL,
      24,
      NULL,
      14.491648,
      12,
      2.174314,
      1.893495,
      NULL,
      0,
      26,
      14,
      19,
      6.082069,
      34.025163,
      9,
      0,
      24.577640,
      NULL,
      NULL,
      87,
      50.255037,
      16.293508,
      ' 1-27-1987',
      17,
      3,
      8.169228,
      3,
      83.081137,
      88.694262,
      ' 1- 8-1983',
      2.097099,
      3,
      2.981640,
      0,
      8.565243,
      NULL,
      3.024972,
      4.663432,
      2,
      0,
      1,
      0,
      1,
      3.036512,
      2,
      0.038314,
      2,
      NULL,
      NULL,
      1.606337,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-15-1987',
      57.894619,
      24.283894,
      NULL,
      5.099111,
      23.533438,
      NULL,
      ' 6-29-2001',
      NULL,
      0.949028,
      NULL,
      0.785407,
      NULL,
      66.331510,
      4,
      0,
      30,
      NULL,
      NULL,
      NULL,
      '10-29-2001',
      12,
      7.625290,
      70,
      63.071398,
      71.909111,
      14,
      68.024110,
      NULL,
      83,
      18,
      44,
      57.064258,
      NULL,
      7,
      16.419646,
      0.210939,
      7,
      4,
      4,
      0.776074,
      ' 7-24-1998',
      3.602895,
      17,
      '11- 3-1992',
      0.425123,
      4,
      12,
      NULL,
      9.688794,
      4.045651,
      NULL,
      9,
      2,
      23.676069,
      0,
      8,
      3.680576,
      18.143890,
      NULL,
      5,
      4.381239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      4,
      ' 8- 1-1982',
      NULL,
      NULL,
      NULL,
      36,
      '10- 4-2003',
      16,
      ' 3-23-1975',
      10.877668,
      2,
      NULL,
      37.456008,
      49,
      ' 3-10-1981',
      NULL,
      0.530842,
      '10-14-1987',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 9- 0-1987',
      9.172300,
      15,
      5,
      ' 6-15-1985',
      4,
      182.324102,
      ' 9-23-1983',
      6,
      96,
      8.518417,
      22,
      ' 0-24-1990',
      14,
      NULL,
      13.801228,
      '10-27-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


