set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0441',
      '14210400',
      '03003400',
      '32231212',
      '03114424',
      '02314420',
      '42044311',
      '34010420',
      '11021000',
      '04123102',
      '31221124',
      '32240412',
      NULL,
      '04210320',
      '02401013',
      '12324131',
      '02202130',
      '43232334',
      '44431313',
      '21002001',
      '31413000',
      '32344013',
      '00341320',
      '00104132',
      '04010132',
      '10340104',
      '24040312',
      NULL,
      NULL,
      '11420422',
      '11330412',
      NULL,
      NULL,
      '23024023',
      '42343310',
      NULL,
      '20020130',
      '34401211',
      '22323003',
      '20431410',
      '14343131',
      '43010230',
      '41132303',
      '14230442',
      '23310301',
      '310',
      '04',
      42.813537,
      16.824731,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      ' 9-27-1992',
      60,
      NULL,
      2.134121,
      8,
      13.929332,
      0.678132,
      3,
      NULL,
      2.585866,
      10,
      NULL,
      NULL,
      14,
      1.056514,
      16.890137,
      9.362589,
      21.211179,
      NULL,
      20,
      19,
      64,
      NULL,
      38,
      7.778399,
      1,
      48,
      NULL,
      68.344228,
      98.047367,
      79.691427,
      129.853216,
      ' 7- 2-1990',
      16,
      7.913349,
      22,
      0.917757,
      46,
      119.988854,
      '10-17-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      NULL,
      NULL,
      33,
      NULL,
      NULL,
      ' 5- 5-1979',
      1.064355,
      0.828343,
      50,
      1.165218,
      1.187927,
      110,
      0,
      3.626038,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-14-1989',
      9.506140,
      53,
      58,
      46.695385,
      NULL,
      79.648872,
      54.462305,
      NULL,
      70.704672,
      21,
      33,
      NULL,
      '11- 6-1995',
      8,
      6,
      9,
      47.276861,
      NULL,
      39.855560,
      5.673106,
      ' 3- 6-1999',
      NULL,
      NULL,
      ' 4- 2-1980',
      10,
      6.841977,
      10.735317,
      8.072144,
      8,
      1.800838,
      0,
      6.632637,
      1,
      34,
      3.793021,
      5,
      NULL,
      NULL,
      0.324948,
      13.112734,
      2.012618,
      NULL,
      ' 3- 1-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      12.022168,
      NULL,
      ' 5-13-1983',
      NULL,
      NULL,
      NULL,
      44.971233,
      NULL,
      39.354797,
      NULL,
      5,
      1.009758,
      '11- 1-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '11-28-1978',
      6,
      25.521972,
      11,
      ' 5-27-1989',
      12.374202,
      74,
      NULL,
      5,
      NULL,
      4.816965,
      23,
      NULL,
      NULL,
      0,
      49.938517,
      ' 1- 3-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


