set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '4',
      '3',
      '3',
      NULL,
      '4',
      '4',
      '2',
      '0',
      '1',
      '3',
      '3',
      '1',
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      '2',
      '1',
      '4',
      '2',
      '3',
      '',
      '2',
      '',
      '1',
      '3',
      '4',
      NULL,
      '1',
      '',
      '',
      '1',
      '0',
      '3',
      '0',
      '3',
      NULL,
      '3',
      '1',
      '0',
      '2',
      '0',
      NULL,
      '02313414',
      NULL,
      34,
      '0343331',
      2.974463,
      119.360023,
      2,
      1,
      NULL,
      3,
      NULL,
      ' 9-26-1980',
      72,
      234.094976,
      19,
      12,
      18.214702,
      NULL,
      11,
      2,
      NULL,
      7.501908,
      20,
      NULL,
      NULL,
      4,
      16,
      9,
      1.504721,
      13,
      53.510227,
      19,
      44,
      NULL,
      4,
      11,
      1.288715,
      NULL,
      22.381629,
      27,
      29.842399,
      NULL,
      74,
      ' 5- 3-2001',
      14.365645,
      NULL,
      2.909779,
      19,
      55.656887,
      82.611390,
      ' 2- 1-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      21.446526,
      7.072526,
      9,
      8.655584,
      NULL,
      '11-13-2003',
      NULL,
      0,
      103.430300,
      1.970290,
      1,
      39,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-25-1985',
      22.458086,
      56,
      36.670277,
      69.926417,
      0.846663,
      NULL,
      56,
      55.130269,
      59,
      30,
      50.035553,
      41.356284,
      ' 1-11-1988',
      8.631738,
      17,
      7.748774,
      NULL,
      38,
      5,
      4.513634,
      NULL,
      0.496432,
      3,
      ' 9-13-1988',
      1.385778,
      6.708121,
      NULL,
      9.271628,
      6,
      1,
      1,
      NULL,
      1.546526,
      NULL,
      0,
      0.625712,
      5,
      NULL,
      4,
      6,
      NULL,
      0.319775,
      ' 6-24-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      116,
      3,
      '10- 9-1996',
      NULL,
      NULL,
      NULL,
      42.681465,
      NULL,
      NULL,
      NULL,
      NULL,
      4.362446,
      ' 2- 4-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      ' 2-14-1984',
      13.949886,
      15,
      NULL,
      NULL,
      NULL,
      159.120741,
      ' 1-29-1981',
      10,
      NULL,
      8,
      29.973936,
      NULL,
      28.766330,
      0.720960,
      73,
      ' 1-27-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


