set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9125661';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4043',
      NULL,
      '01241124',
      NULL,
      '21020022',
      '01334303',
      '44233323',
      '03024311',
      '42120400',
      '40233201',
      '21023034',
      '44021114',
      NULL,
      '04414322',
      '30330311',
      '10204211',
      '13200411',
      '21021134',
      NULL,
      '21123442',
      '41230232',
      NULL,
      '34301122',
      '20400021',
      NULL,
      '31011111',
      '31044202',
      '34013412',
      '32022222',
      '00131403',
      '42400300',
      '30141004',
      '14342334',
      '41414422',
      '41400100',
      '43243243',
      '10102414',
      '11112022',
      NULL,
      '12121344',
      '10301034',
      NULL,
      '22201033',
      '10402443',
      '04312141',
      '344',
      '22',
      24.301969,
      0.645575,
      '0400004',
      0,
      0,
      3,
      NULL,
      '113102',
      1,
      ' 5- 2-1974',
      ' 5-26-2002',
      73,
      NULL,
      35,
      1.902768,
      20.107702,
      NULL,
      93.801806,
      0.269273,
      22,
      7.642872,
      NULL,
      5.245730,
      24.002658,
      7,
      8.387407,
      NULL,
      NULL,
      19,
      1,
      1,
      9,
      5.287032,
      169,
      NULL,
      1.888529,
      NULL,
      86.106893,
      39,
      NULL,
      NULL,
      84.843004,
      NULL,
      11.894765,
      14.066006,
      10.256497,
      NULL,
      149,
      228.488748,
      ' 9-10-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      48.269489,
      3,
      0.315494,
      3,
      7.573037,
      7,
      NULL,
      0.037416,
      NULL,
      142.496922,
      0,
      0,
      151,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-16-1994',
      73.286314,
      104.012486,
      54,
      4,
      87.960885,
      NULL,
      58.799629,
      60,
      47.417018,
      NULL,
      19,
      81.904605,
      ' 6-18-1975',
      NULL,
      8,
      NULL,
      25,
      77.346325,
      82,
      NULL,
      ' 3-15-1992',
      15.683262,
      29,
      ' 1- 0-1987',
      NULL,
      7.013809,
      NULL,
      NULL,
      NULL,
      12,
      0,
      NULL,
      1,
      0,
      1,
      2.929177,
      NULL,
      NULL,
      1,
      0.873066,
      0.048420,
      1.788115,
      ' 2- 3-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      137,
      7,
      '10- 2-2002',
      NULL,
      NULL,
      NULL,
      39,
      NULL,
      5.191702,
      ' 7-19-1989',
      17.067962,
      14,
      ' 3-10-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      '10- 5-1999',
      NULL,
      3,
      34.548869,
      ' 3-23-1975',
      1.996892,
      NULL,
      ' 5-17-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


