set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9400859';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3424',
      '44144004',
      '01414342',
      '02223003',
      '32344043',
      '14030020',
      '03344233',
      '04300213',
      '40420311',
      '34041320',
      '24402142',
      '33031241',
      NULL,
      '33031431',
      '42413001',
      NULL,
      '41243413',
      '42042213',
      '11421221',
      '42123241',
      '00020403',
      '10411423',
      '33402042',
      '43443311',
      '24101321',
      '23224400',
      '33010202',
      '22022323',
      NULL,
      NULL,
      '42040330',
      '03303420',
      '23412441',
      '31203041',
      '01144012',
      '44414304',
      '43102122',
      '23114121',
      '13000331',
      '32112243',
      NULL,
      NULL,
      NULL,
      '13111120',
      '22011404',
      '433',
      NULL,
      NULL,
      NULL,
      '3401224',
      0,
      NULL,
      1,
      NULL,
      '402234',
      NULL,
      '10- 3-2003',
      ' 8- 1-1974',
      20,
      NULL,
      41.684317,
      NULL,
      19.882113,
      4.641994,
      98.085680,
      26.015500,
      NULL,
      6.763229,
      46.749595,
      20.722538,
      11.836395,
      2.237948,
      6,
      18,
      29.396292,
      18.958255,
      45.379147,
      2,
      40,
      24,
      59.496145,
      16.597134,
      0.646408,
      104,
      187,
      49,
      197.984068,
      NULL,
      71,
      ' 3- 1-1981',
      20,
      9,
      NULL,
      16.023252,
      157,
      87,
      ' 9-24-1987',
      1,
      NULL,
      0,
      0.250511,
      0,
      1.860936,
      0.002263,
      3,
      1,
      NULL,
      0,
      0.368424,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0.318370,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-25-1980',
      91.386199,
      8,
      NULL,
      1.190804,
      1.171179,
      NULL,
      ' 9-22-1999',
      NULL,
      NULL,
      188.908485,
      1.959716,
      1.475610,
      149.885307,
      1.941213,
      0,
      47,
      NULL,
      NULL,
      NULL,
      ' 5-11-1991',
      NULL,
      11,
      47,
      11,
      NULL,
      10,
      NULL,
      4,
      NULL,
      80.115442,
      87.627208,
      81,
      NULL,
      35,
      32,
      15.274729,
      10.656459,
      108.801144,
      4,
      NULL,
      '11- 0-1979',
      22,
      11,
      ' 7-16-2003',
      NULL,
      NULL,
      16.190306,
      23,
      11.527721,
      NULL,
      NULL,
      NULL,
      0.347251,
      97.622904,
      0.915449,
      1.960997,
      NULL,
      13,
      3,
      NULL,
      NULL,
      0,
      ' 5- 8-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      73.219060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      ' 0- 3-1990',
      29,
      ' 2- 4-1992',
      0,
      12,
      ' 8-24-1978',
      121.291260,
      61,
      NULL,
      0.845514,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      11,
      ' 8-14-1991',
      33.327267,
      40.577760,
      48,
      ' 6- 4-1987',
      1.613998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


