set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9628992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      '1',
      '3',
      '4',
      '3',
      '4',
      '2',
      '1',
      '4',
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      '3',
      NULL,
      '2',
      '4',
      NULL,
      '',
      '0',
      '',
      '3',
      '2',
      NULL,
      NULL,
      '0',
      '',
      '',
      '2',
      NULL,
      '4',
      '1',
      '3',
      '2',
      '0',
      '0',
      '3',
      NULL,
      '1',
      '120',
      NULL,
      9.181437,
      23.648931,
      NULL,
      0.388043,
      NULL,
      2,
      NULL,
      '043133',
      0,
      ' 9-28-1978',
      ' 5-17-2000',
      71,
      26,
      NULL,
      NULL,
      2,
      13,
      NULL,
      6,
      12.859091,
      7.145451,
      13,
      4.941275,
      30,
      NULL,
      23,
      11,
      17,
      3.392998,
      31.058230,
      3.970497,
      2.367790,
      2.683987,
      76,
      1,
      1.052379,
      76,
      165,
      68.006651,
      12,
      163.616606,
      81.936332,
      ' 0-13-1989',
      51,
      19.046555,
      26.924551,
      13.671784,
      NULL,
      125,
      ' 3-13-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      65,
      42,
      38.498152,
      1.945662,
      27,
      5,
      ' 1-23-1998',
      1,
      1,
      NULL,
      1.968550,
      2.073750,
      78,
      1,
      4.512700,
      5,
      NULL,
      NULL,
      NULL,
      ' 2-13-1976',
      24,
      33.698711,
      89,
      NULL,
      NULL,
      49.676778,
      NULL,
      56,
      81.633211,
      2,
      26.812664,
      67.105362,
      NULL,
      19.708165,
      2.206787,
      NULL,
      13.450461,
      NULL,
      NULL,
      8.714990,
      ' 7- 8-1987',
      4.001597,
      NULL,
      ' 9- 3-2002',
      2.512359,
      3,
      18,
      7.957642,
      3.958641,
      NULL,
      1.399364,
      2.273281,
      1,
      98,
      2.593307,
      0.503566,
      3.408710,
      18.036902,
      NULL,
      0.666218,
      1,
      1.342998,
      ' 6-16-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      ' 2-27-1976',
      NULL,
      NULL,
      NULL,
      39,
      NULL,
      35,
      ' 6-26-1987',
      NULL,
      3,
      NULL,
      61.612339,
      86.912072,
      ' 5- 1-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      30,
      NULL,
      3,
      ' 6- 6-1999',
      1,
      NULL,
      ' 2- 4-1983',
      4,
      28.738706,
      5.814891,
      40.508334,
      ' 8-21-1988',
      26,
      NULL,
      202,
      '11-28-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


