set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921944';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2200',
      '01202144',
      '21323012',
      '03440102',
      '14433113',
      NULL,
      '21244103',
      '10224113',
      '11424313',
      '42434344',
      NULL,
      '32440240',
      '14204014',
      NULL,
      '31110244',
      '12000400',
      '43033321',
      NULL,
      '10202430',
      '04112002',
      '03444101',
      '12011201',
      '14423314',
      '03240134',
      '42330010',
      NULL,
      NULL,
      '23411103',
      '43141022',
      '32303101',
      '30333430',
      '12134332',
      NULL,
      '04002031',
      '43111412',
      '11030133',
      '12210004',
      '11004112',
      '41203020',
      '10400310',
      '01233441',
      '42101034',
      '40111034',
      '14022031',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '1333021',
      3.277993,
      1,
      2,
      NULL,
      NULL,
      2.815620,
      NULL,
      ' 8-11-2003',
      39,
      NULL,
      NULL,
      NULL,
      4,
      13.679347,
      NULL,
      NULL,
      NULL,
      10,
      5.567486,
      1,
      26.031484,
      6,
      1,
      5.979232,
      8.502023,
      10.419769,
      50,
      4.318462,
      39.600529,
      0.668365,
      65,
      5,
      NULL,
      NULL,
      17,
      26.431460,
      43.339662,
      NULL,
      114.734843,
      ' 9-29-1979',
      NULL,
      NULL,
      25,
      10.131367,
      42,
      62.845536,
      ' 7- 8-2003',
      NULL,
      NULL,
      2.789127,
      7.856776,
      NULL,
      NULL,
      NULL,
      NULL,
      1.730638,
      1.208498,
      1.983456,
      0,
      1.178918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 9-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-10-2001',
      137.032869,
      167.167456,
      148,
      76.810495,
      49,
      72.359865,
      61.835319,
      17,
      98,
      115,
      148,
      NULL,
      ' 6-17-1978',
      5.913635,
      22,
      13.804821,
      29.173813,
      46,
      70.800364,
      10,
      ' 1-17-1995',
      25,
      6.165944,
      '11-15-1980',
      3.971243,
      2,
      NULL,
      12,
      6,
      0,
      NULL,
      8,
      NULL,
      45,
      1,
      0.073845,
      3.671252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 1-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.255947,
      ' 3- 6-2003',
      1,
      48,
      ' 8- 0-1976',
      1,
      NULL,
      20,
      28,
      ' 5-27-2000',
      50.504573,
      0.034922,
      NULL,
      ' 0-22-1992',
      NULL,
      NULL,
      NULL,
      35.652806,
      0.313164,
      15,
      62.995677,
      54.776855,
      54,
      46.754202,
      NULL,
      NULL,
      121,
      0.927536,
      32,
      2,
      1.848671,
      56,
      2,
      0.630533,
      21.660157,
      3,
      0.532032,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      12.975599,
      NULL,
      32.769471,
      NULL,
      1.050528,
      1,
      0,
      0.723349,
      1,
      NULL,
      32,
      53,
      16.188390,
      28.242667,
      22.715393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914840,
      2,
      1,
      0,
      32.145293,
      9,
      2.467978,
      NULL,
      40.052147,
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-18-1993',
      ' 6-17-1986',
      NULL,
      NULL,
      '11-19-1974',
      NULL,
      NULL,
      NULL);
commit;
end;
/


