set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8927024';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34434343',
      '12410324',
      NULL,
      '02421030',
      '13343204',
      '42201142',
      '14423444',
      NULL,
      '20313202',
      '40411302',
      '32032441',
      '14023333',
      '33432423',
      NULL,
      '00424343',
      '30023444',
      '02113412',
      NULL,
      '41341341',
      '33031303',
      NULL,
      '04300003',
      '02424133',
      NULL,
      NULL,
      '24423113',
      '43131043',
      '01041220',
      '34240440',
      '40233241',
      '44103441',
      '32002442',
      '10121030',
      '24330134',
      '03433214',
      '42102340',
      '24201142',
      '43400420',
      '33321012',
      '41340333',
      '03224423',
      '04024021',
      '32141230',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '1301431',
      1.959973,
      0.896528,
      NULL,
      NULL,
      NULL,
      3.749160,
      '10- 1-1981',
      ' 1-28-1976',
      30,
      NULL,
      20,
      13.623690,
      8,
      0,
      110,
      9.176946,
      23.356585,
      26,
      29.556487,
      14,
      35.176521,
      16,
      12.621208,
      15,
      18,
      15.858784,
      3.058854,
      6.735896,
      30,
      8.060829,
      99,
      0,
      NULL,
      95.280363,
      86.332867,
      21,
      1.422655,
      NULL,
      NULL,
      NULL,
      37,
      10.324042,
      NULL,
      5.294978,
      66,
      117,
      ' 3-17-2002',
      NULL,
      1,
      1.508214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.668181,
      1.334999,
      5.962073,
      0,
      0.488231,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 5-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-13-2002',
      63,
      NULL,
      124,
      67.285533,
      12,
      10,
      62.730627,
      91,
      28,
      83.700093,
      NULL,
      NULL,
      '10- 4-1976',
      17.920950,
      15,
      1,
      11,
      NULL,
      25,
      9,
      ' 1-19-1994',
      NULL,
      0,
      ' 6-25-1989',
      1.640711,
      1,
      10,
      13,
      0,
      1,
      NULL,
      1.530775,
      NULL,
      NULL,
      1,
      0.771081,
      1.995055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 3-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      70.776416,
      43,
      17.770353,
      ' 7- 3-1979',
      0.195085,
      118.505899,
      '11-10-1982',
      16,
      41,
      5.751228,
      31.680401,
      ' 7-11-1988',
      0,
      0,
      79.100475,
      NULL,
      NULL,
      NULL,
      NULL,
      51.807844,
      121.739970,
      72.829553,
      NULL,
      89.842954,
      NULL,
      13,
      3,
      NULL,
      2,
      10.483560,
      NULL,
      0,
      4.345113,
      NULL,
      1,
      5,
      40.811659,
      2.368272,
      NULL,
      106,
      0,
      NULL,
      NULL,
      20,
      33,
      28.531017,
      1,
      29,
      0,
      NULL,
      1.369310,
      0,
      4.685292,
      1.544022,
      NULL,
      87,
      65,
      NULL,
      62.565166,
      93,
      1,
      3.477445,
      NULL,
      2,
      1,
      0,
      15,
      0,
      18.443057,
      NULL,
      77.969811,
      1,
      0,
      113,
      NULL,
      11.587027,
      25,
      8.477534,
      16.358333,
      6,
      NULL,
      6.111401,
      NULL,
      1,
      1,
      0,
      3,
      1,
      0,
      113,
      ' 9-16-1996',
      NULL,
      ' 2-20-1986',
      ' 0-26-1989',
      NULL,
      ' 4-15-1984',
      ' 8-26-1984',
      NULL);
commit;
end;
/


