set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7711518';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '42443143',
      NULL,
      '40121413',
      '30441014',
      '24124430',
      NULL,
      NULL,
      '42413131',
      '30220311',
      '40302303',
      '04330413',
      '21014440',
      '34240342',
      '33202024',
      '24144113',
      '00313242',
      NULL,
      NULL,
      '12320030',
      '34420421',
      NULL,
      NULL,
      '02113101',
      NULL,
      '02411320',
      '31424013',
      '11104110',
      '41144423',
      NULL,
      '41431324',
      '23343101',
      '23233232',
      '40311424',
      '34221142',
      NULL,
      '22140122',
      '34044112',
      NULL,
      '34314202',
      '20402304',
      '42421133',
      '03230402',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '2440322',
      2.238469,
      1,
      3,
      NULL,
      NULL,
      2,
      ' 7-21-1998',
      ' 8-10-1982',
      20,
      NULL,
      3,
      4,
      0,
      2.732857,
      55.643011,
      NULL,
      7.781112,
      NULL,
      31,
      24.402002,
      48.332243,
      NULL,
      16,
      18.470635,
      1.828348,
      NULL,
      33.960950,
      3.146282,
      35.613356,
      NULL,
      20,
      3.740029,
      NULL,
      0.392116,
      44.342598,
      41.553823,
      88.165441,
      NULL,
      153,
      ' 8-24-1987',
      55,
      27.479931,
      32.528475,
      3,
      16,
      NULL,
      NULL,
      2.568949,
      9,
      1.994022,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      3.493377,
      0,
      5.419813,
      0,
      0.511611,
      0.857184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 9-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      111,
      55,
      NULL,
      29.784385,
      6,
      29,
      NULL,
      37.715681,
      ' 2- 1-1999',
      7.181127,
      3,
      19,
      27.510255,
      35,
      129.766374,
      6.100876,
      '11- 7-1984',
      19.214286,
      NULL,
      ' 0-15-1992',
      NULL,
      1.473527,
      NULL,
      12,
      NULL,
      16.034211,
      NULL,
      3.691654,
      NULL,
      51,
      4.731480,
      NULL,
      5.872407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-27-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      20.107021,
      NULL,
      ' 4- 0-1982',
      2,
      484,
      ' 9- 0-1994',
      NULL,
      19.898415,
      17,
      70.665066,
      '10-16-2001',
      6,
      0.467177,
      4.778771,
      ' 8- 2-1985',
      NULL,
      NULL,
      NULL,
      49,
      73,
      50,
      NULL,
      NULL,
      130.655436,
      89,
      9,
      20.198917,
      29,
      NULL,
      80.187399,
      1,
      0.435266,
      34,
      3,
      0,
      90.097513,
      NULL,
      1,
      105.621260,
      0,
      1.555788,
      NULL,
      NULL,
      2.601545,
      13,
      NULL,
      32.701302,
      0,
      1,
      1,
      0.366810,
      0.669713,
      NULL,
      61.056223,
      69,
      120,
      NULL,
      2.932750,
      48.862831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      96,
      1.575330,
      1.421831,
      42.428861,
      NULL,
      11,
      25,
      51.063624,
      5.344002,
      NULL,
      59,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-11-1994',
      ' 0-10-1986',
      ' 5-27-1987',
      NULL,
      ' 5-29-1985',
      '11-15-1999',
      NULL,
      NULL);
commit;
end;
/


