set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9982784';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '1',
      '0',
      NULL,
      '2',
      '0',
      '0',
      NULL,
      '2',
      '0',
      NULL,
      '0',
      '1',
      '4',
      NULL,
      '2',
      '2',
      '1',
      '0',
      '1',
      '1',
      NULL,
      '3',
      '',
      '3',
      '',
      '1',
      '0',
      '0',
      '2',
      '0',
      '',
      '',
      '0',
      NULL,
      '1',
      '1',
      '1',
      '2',
      '0',
      '4',
      '0',
      '3',
      '1',
      NULL,
      NULL,
      15,
      28.935421,
      '0114331',
      0.361785,
      1.148724,
      1,
      1,
      '314424',
      NULL,
      ' 2-25-1997',
      ' 9- 6-1990',
      2.047747,
      NULL,
      NULL,
      3.554229,
      NULL,
      NULL,
      31.369935,
      1.145090,
      12.186502,
      0.438046,
      43,
      12,
      1,
      11,
      18,
      11,
      NULL,
      18,
      77,
      19.075172,
      20.047397,
      NULL,
      43,
      3,
      1,
      111,
      NULL,
      103,
      NULL,
      98,
      76.769449,
      '11-10-1984',
      4,
      59.810523,
      0,
      NULL,
      194,
      77,
      ' 8- 2-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42.279030,
      0,
      8,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      14.600407,
      0,
      1,
      43,
      1.358023,
      0,
      60.315069,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      39,
      17.408813,
      46.205130,
      51.329566,
      NULL,
      61,
      NULL,
      NULL,
      7,
      38.056450,
      81.809874,
      ' 7- 1-1989',
      5,
      23,
      19,
      48.019782,
      116.292658,
      112,
      13.941932,
      NULL,
      3.146638,
      6,
      ' 3- 1-1986',
      14.831507,
      6.377793,
      23,
      6,
      4,
      16,
      0,
      16.538410,
      0.428605,
      93.954186,
      0,
      NULL,
      7.037576,
      NULL,
      0.839826,
      0.722923,
      NULL,
      1,
      '11-18-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      227.488313,
      2,
      ' 6-29-1981',
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      10.421285,
      ' 6- 1-1975',
      NULL,
      16.990640,
      ' 9-18-1993',
      59,
      40.740176,
      ' 9-17-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      21,
      ' 1- 9-1989',
      7,
      31.306927,
      27,
      '10-10-1986',
      NULL,
      39.991953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


