set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9115538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02101310',
      NULL,
      '41232240',
      '32222341',
      NULL,
      '11201224',
      '42133304',
      '34033414',
      '01041322',
      '20022042',
      '43324240',
      '33234001',
      NULL,
      '42423034',
      NULL,
      '32000343',
      '31144242',
      NULL,
      '31340212',
      '14221310',
      '13042301',
      '22413331',
      '22144421',
      NULL,
      '32021341',
      '33113101',
      '33331020',
      '14412240',
      '32120204',
      '02303340',
      '31341130',
      NULL,
      NULL,
      '02403220',
      '41201042',
      '40202342',
      '01411304',
      '41041223',
      '21404401',
      NULL,
      '20000443',
      '30040102',
      '23141014',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '1113441',
      2.505904,
      0.903158,
      0,
      NULL,
      '131340',
      NULL,
      ' 6-26-1984',
      '10-29-1980',
      2,
      NULL,
      NULL,
      15.491386,
      5,
      3.207349,
      124.687772,
      3.107417,
      1,
      29,
      7.569509,
      23,
      NULL,
      16.319468,
      NULL,
      1,
      27.611121,
      20,
      5,
      NULL,
      NULL,
      22,
      NULL,
      3,
      NULL,
      126,
      34,
      86.103923,
      115,
      NULL,
      50.479630,
      ' 4-28-1982',
      52,
      NULL,
      11,
      18.205562,
      149,
      223.582475,
      ' 5-23-1990',
      1.559016,
      NULL,
      1.356434,
      0.668867,
      NULL,
      NULL,
      NULL,
      NULL,
      0.120657,
      0,
      NULL,
      1,
      0,
      0.478078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 0-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-15-1999',
      89,
      0.475953,
      NULL,
      NULL,
      33,
      117,
      NULL,
      106,
      38,
      22,
      69,
      83.234526,
      '10-14-1988',
      34,
      21.962806,
      23,
      5,
      27,
      61,
      12.493085,
      ' 3- 0-1977',
      18,
      13.751697,
      ' 2-23-1984',
      NULL,
      12,
      3,
      25.115066,
      1.649827,
      6,
      NULL,
      16,
      NULL,
      61.447521,
      0,
      5.077029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.484464,
      NULL,
      NULL,
      NULL,
      1.021670,
      62.397030,
      ' 2-26-1995',
      12.714563,
      17,
      20,
      24,
      NULL,
      66.015912,
      1.124176,
      67.115638,
      '11-25-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      1.929571,
      0.970686,
      NULL,
      NULL,
      116.883156,
      2.324457,
      2.617416,
      4.279484,
      0.626425,
      3.130838,
      NULL,
      0,
      0,
      57,
      NULL,
      NULL,
      NULL,
      1.002719,
      NULL,
      132.515748,
      NULL,
      1,
      65,
      NULL,
      13,
      NULL,
      0.285202,
      NULL,
      NULL,
      0.851000,
      1,
      1.781866,
      0.720845,
      1.889817,
      NULL,
      NULL,
      NULL,
      22.507094,
      NULL,
      NULL,
      0,
      NULL,
      42,
      1.034408,
      0,
      3.336240,
      59,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.250672,
      1.058661,
      0.158247,
      1,
      0.009853,
      NULL,
      NULL,
      NULL,
      '10-12-2003',
      ' 8-19-1998',
      ' 8-16-1994',
      ' 8-20-1991',
      ' 5-17-1986',
      ' 7-23-1989',
      NULL);
commit;
end;
/


