set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3375557';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      '3',
      NULL,
      '4',
      '0',
      '3',
      '0',
      NULL,
      '0',
      '4',
      '1',
      '2',
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      '0',
      NULL,
      '1',
      '4',
      NULL,
      '1',
      '',
      '1',
      '2',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '3',
      '0',
      '4',
      NULL,
      '1',
      '1',
      '0',
      '4',
      '0',
      '1',
      '4',
      NULL,
      NULL,
      59,
      83.206354,
      NULL,
      0,
      1.986149,
      2,
      NULL,
      '134440',
      1.962694,
      ' 6-21-1988',
      ' 6- 6-1990',
      73,
      228,
      2.489999,
      13.221408,
      31.263431,
      8.975272,
      49.512847,
      4,
      3,
      1.989972,
      12.456507,
      12,
      11,
      2,
      11.480934,
      13,
      NULL,
      17,
      75,
      29.735348,
      18,
      19,
      77,
      5.712918,
      1,
      8.846811,
      100,
      21.265240,
      231,
      150.012107,
      NULL,
      ' 0-17-1986',
      51,
      3,
      NULL,
      1.658170,
      35.573965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.235675,
      17,
      20.635318,
      20,
      2,
      ' 9-20-1975',
      1.561508,
      0.029894,
      79.524718,
      1,
      NULL,
      84.078483,
      0,
      NULL,
      53.170091,
      NULL,
      NULL,
      NULL,
      ' 6-11-1997',
      32,
      NULL,
      33,
      61.085985,
      64.245923,
      17.951693,
      11.899957,
      NULL,
      46.093918,
      73,
      14,
      47.132354,
      ' 9- 1-1991',
      5.004334,
      18.168152,
      9.340653,
      55.567732,
      NULL,
      112,
      2,
      '11- 6-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      17.946790,
      NULL,
      5.633174,
      NULL,
      8.691201,
      1.146313,
      64.659084,
      NULL,
      0.666630,
      NULL,
      11,
      NULL,
      1,
      NULL,
      NULL,
      ' 3-26-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      299.613599,
      NULL,
      ' 3-15-1975',
      NULL,
      NULL,
      NULL,
      19,
      ' 4-17-1994',
      26.676403,
      '11-19-1977',
      4.101544,
      13,
      NULL,
      50.629486,
      121,
      ' 4- 1-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      11.158795,
      ' 2-25-1981',
      28.373747,
      40.531546,
      34,
      ' 3-11-1974',
      0.183374,
      NULL,
      ' 7-29-1988',
      12,
      23,
      15,
      32.410750,
      NULL,
      4,
      0,
      47,
      ' 2-29-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


