set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9763902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '3',
      '3',
      '0',
      '1',
      '2',
      NULL,
      '4',
      NULL,
      '1',
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      '1',
      '0',
      NULL,
      '2',
      '4',
      '0',
      '3',
      '3',
      '',
      '0',
      '',
      '0',
      NULL,
      '1',
      '3',
      NULL,
      '',
      '',
      NULL,
      '1',
      '0',
      NULL,
      '3',
      NULL,
      '4',
      '2',
      '2',
      '2',
      '3',
      '222',
      '20031103',
      NULL,
      52.864430,
      '2130400',
      3.726541,
      NULL,
      2,
      NULL,
      NULL,
      0.860438,
      ' 3-25-1982',
      ' 6-14-2000',
      92,
      65.234976,
      21,
      7,
      24,
      4,
      73.062569,
      8,
      23.359597,
      23,
      NULL,
      1,
      34.094913,
      17,
      NULL,
      2.966979,
      8,
      9,
      33.022318,
      NULL,
      10,
      3.348263,
      5,
      9.616034,
      1.108601,
      72.064616,
      167.160818,
      45,
      136.069567,
      41,
      76.757406,
      ' 7-17-1979',
      16.939698,
      15.988566,
      33,
      NULL,
      185.982244,
      58,
      ' 9-12-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.573053,
      18.711041,
      3,
      33.683167,
      19.143576,
      NULL,
      '10-13-1990',
      NULL,
      0,
      52.307062,
      0.940554,
      NULL,
      81.084104,
      0.850861,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-21-1976',
      13,
      40.177051,
      38.167072,
      NULL,
      66.713702,
      NULL,
      70,
      NULL,
      51,
      12.942596,
      14,
      52.636912,
      NULL,
      4,
      NULL,
      15.837214,
      NULL,
      8.010840,
      38.578297,
      NULL,
      ' 9-29-1998',
      21.711509,
      21.952111,
      ' 8-28-1990',
      2.208903,
      14,
      7,
      3,
      26.620999,
      13,
      1,
      6.803066,
      1,
      70,
      3,
      0,
      19,
      NULL,
      1,
      0.908048,
      0.905417,
      NULL,
      ' 0-14-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      19.510169,
      19,
      ' 4-20-1979',
      NULL,
      NULL,
      NULL,
      35.942032,
      ' 7-29-1990',
      19,
      NULL,
      17,
      9,
      ' 2-12-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      18,
      NULL,
      39,
      NULL,
      4.773722,
      ' 5-23-2002',
      1,
      153.590058,
      ' 4- 8-1993',
      3,
      49,
      8,
      90,
      NULL,
      31,
      1.519338,
      60,
      ' 0- 7-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


