set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9763902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      '0',
      NULL,
      '1',
      '4',
      '0',
      '4',
      NULL,
      '0',
      '1',
      '4',
      '2',
      NULL,
      '1',
      '1',
      NULL,
      '3',
      '0',
      NULL,
      '4',
      '4',
      '2',
      '0',
      '',
      '2',
      '',
      '3',
      '1',
      '4',
      '3',
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      '0',
      '4',
      '1',
      NULL,
      NULL,
      '3',
      '1',
      '3',
      '0',
      '431',
      '43034230',
      NULL,
      11.866838,
      '1441203',
      2.256186,
      46,
      0,
      NULL,
      '201242',
      4.522912,
      NULL,
      '10- 7-1996',
      NULL,
      125,
      NULL,
      10.174295,
      17.323622,
      1.157610,
      69,
      6,
      10.334828,
      9.898969,
      0,
      6,
      10,
      25.529159,
      NULL,
      2,
      12.615792,
      NULL,
      13,
      8,
      10.015334,
      4.609391,
      39.416500,
      15,
      1.698677,
      30,
      179,
      NULL,
      1,
      84.019286,
      127,
      ' 5-15-2003',
      20,
      NULL,
      8.542407,
      NULL,
      NULL,
      179.484769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      NULL,
      2,
      15,
      12,
      NULL,
      ' 7-21-1981',
      1,
      0.045938,
      1,
      1.439461,
      NULL,
      NULL,
      1.995518,
      0.242827,
      62.799812,
      NULL,
      NULL,
      NULL,
      ' 5-22-1985',
      20.076453,
      NULL,
      10.693577,
      NULL,
      71,
      11.678975,
      24,
      13,
      37.342285,
      NULL,
      28.756206,
      65,
      ' 9- 4-1990',
      8,
      14.340200,
      NULL,
      23,
      36,
      21.076961,
      NULL,
      ' 3-26-1977',
      4,
      1,
      '11- 5-1986',
      2.476168,
      12.597643,
      NULL,
      NULL,
      16.929918,
      10,
      1.392045,
      15,
      0.404130,
      93.042727,
      0,
      NULL,
      NULL,
      26.423783,
      1,
      NULL,
      0,
      1,
      ' 1- 9-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      65.123874,
      14,
      ' 1-19-1998',
      NULL,
      NULL,
      NULL,
      24,
      ' 4-13-1990',
      NULL,
      ' 7-26-1983',
      6.640801,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      21,
      ' 9-20-2002',
      21,
      13,
      3,
      ' 2-20-1978',
      0,
      78,
      ' 5-21-1989',
      6.314081,
      30,
      19,
      69,
      ' 8-27-1994',
      60.449683,
      1,
      47,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


