set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9215948';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4121',
      NULL,
      '33442232',
      NULL,
      '34312032',
      '40011223',
      '02433314',
      '43103124',
      '32003343',
      NULL,
      '24301234',
      NULL,
      NULL,
      '34302440',
      '22201224',
      NULL,
      '33432240',
      '41301030',
      '32324201',
      '22100132',
      NULL,
      '44201211',
      '04103142',
      '11202312',
      '34423112',
      NULL,
      '41130241',
      NULL,
      '03213032',
      '13004432',
      '02102124',
      '14322004',
      '12211130',
      '24011331',
      '14321213',
      '10241231',
      NULL,
      '24212241',
      NULL,
      '33344433',
      '30044234',
      '23330141',
      NULL,
      '03332303',
      '44242403',
      NULL,
      '30',
      NULL,
      NULL,
      '0313014',
      1,
      1,
      NULL,
      NULL,
      '113234',
      0.521886,
      '11- 2-1997',
      ' 3- 1-1982',
      NULL,
      NULL,
      NULL,
      5.515410,
      10,
      12.008147,
      25,
      NULL,
      NULL,
      13,
      27,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      17,
      22,
      66.449921,
      20.548555,
      27,
      26,
      135.316520,
      14,
      NULL,
      73,
      8,
      NULL,
      128,
      102.516978,
      101.592722,
      '10- 7-2000',
      11.393526,
      24,
      18.732704,
      5.530493,
      52.915715,
      53,
      ' 5-18-2000',
      1.450790,
      2,
      1,
      1.425344,
      1.923388,
      1.805119,
      0.399940,
      2,
      NULL,
      0.767332,
      0,
      0.235074,
      0,
      3,
      1,
      0,
      0.098074,
      1.445836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 9-1979',
      NULL,
      67.970974,
      10,
      63.018229,
      11.867833,
      2,
      ' 3- 9-1975',
      1.998301,
      0.579342,
      147.016790,
      1,
      0,
      NULL,
      NULL,
      0,
      33,
      1.484625,
      1.653681,
      17.653392,
      ' 2-17-1977',
      23,
      NULL,
      22,
      83.625087,
      65.148303,
      NULL,
      NULL,
      13.534836,
      NULL,
      54,
      13,
      57,
      ' 7-10-1990',
      41.029982,
      31,
      NULL,
      85.362255,
      129.899075,
      NULL,
      5.794504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.164220,
      6.759829,
      3.179401,
      NULL,
      113,
      3.681708,
      ' 4-21-1999',
      18.302167,
      9,
      '11- 7-2001',
      3,
      ' 2-14-2003',
      2,
      ' 6- 3-1999',
      4,
      NULL,
      ' 6- 6-1994',
      72,
      72,
      ' 0-22-1980',
      9.391352,
      1,
      NULL,
      NULL,
      2.563670,
      '10-16-1980',
      3,
      1,
      11.915200,
      ' 8- 1-1976',
      73,
      NULL,
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2);
commit;
end;
/


