set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8729166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2243',
      '22301031',
      '02223014',
      NULL,
      '33123031',
      '44310244',
      '34440131',
      '40323241',
      '22322023',
      NULL,
      '24234121',
      '21401130',
      '41411030',
      '34342200',
      NULL,
      '31104211',
      '43243113',
      '31213212',
      '33110344',
      '32100221',
      '11404024',
      '22044122',
      '01413100',
      '34030221',
      NULL,
      '21044434',
      '13121410',
      '21420111',
      '34103004',
      '12242141',
      NULL,
      '12423044',
      '04112203',
      '03234310',
      '01430242',
      '42014130',
      '23100422',
      '12022302',
      '14331330',
      NULL,
      NULL,
      NULL,
      '31330313',
      '12304341',
      '11103231',
      '',
      '',
      NULL,
      NULL,
      '4111314',
      2,
      1.582281,
      3,
      NULL,
      '142430',
      NULL,
      ' 9-14-1983',
      ' 0- 1-1993',
      27.752067,
      NULL,
      10.037656,
      NULL,
      0,
      26,
      53.907417,
      23,
      30.354196,
      23,
      4.722368,
      19.867672,
      22,
      9.160144,
      5,
      9,
      23.669070,
      17.354269,
      8.493651,
      NULL,
      37,
      7,
      38,
      8,
      NULL,
      107,
      102.849525,
      81,
      115,
      2,
      179.179920,
      NULL,
      32.806624,
      NULL,
      5.216185,
      22,
      NULL,
      NULL,
      ' 4- 5-2000',
      NULL,
      NULL,
      0.153939,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.459331,
      1,
      2,
      1,
      1.759439,
      0.932767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-22-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 3-1981',
      149,
      NULL,
      134,
      123.223556,
      131,
      96.907808,
      91,
      110,
      119,
      134.559649,
      114,
      1.776128,
      NULL,
      8,
      5,
      17.427430,
      6,
      45,
      NULL,
      7.099947,
      NULL,
      NULL,
      22.210939,
      ' 9-25-1976',
      NULL,
      0,
      NULL,
      14,
      10.491570,
      9.762509,
      NULL,
      13,
      NULL,
      15.522358,
      0,
      1.354719,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 8-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27.367426,
      NULL,
      34,
      ' 3-17-1977',
      NULL,
      225,
      ' 9- 3-1989',
      11.376451,
      21,
      9,
      17.790875,
      ' 4-29-1974',
      62,
      NULL,
      NULL,
      ' 9-10-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      142,
      7,
      NULL,
      25,
      33,
      43.694407,
      NULL,
      21,
      2.725288,
      NULL,
      59.219820,
      1,
      1,
      2,
      0,
      1.737596,
      27,
      0.672464,
      NULL,
      23.803758,
      0.059441,
      2,
      59,
      NULL,
      14.677677,
      NULL,
      1,
      16,
      1.854564,
      0,
      0,
      1.172505,
      1,
      0.484370,
      36.264625,
      27,
      55,
      24,
      NULL,
      30.398478,
      NULL,
      NULL,
      14,
      1.369379,
      NULL,
      0.742408,
      20,
      0,
      47,
      0.465088,
      40.867632,
      0.057234,
      1.173018,
      10,
      17,
      12.581066,
      NULL,
      56,
      7.972813,
      NULL,
      48.488621,
      NULL,
      5.000294,
      NULL,
      4,
      0.647365,
      0.480513,
      NULL,
      3,
      2,
      '11-13-1992',
      ' 7-11-1985',
      ' 1- 6-1998',
      ' 5- 2-1977',
      '11- 3-1979',
      ' 2-27-1997',
      '10- 7-1980',
      NULL);
commit;
end;
/


