set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038596';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1414',
      NULL,
      NULL,
      '01044313',
      NULL,
      '13104343',
      '22213423',
      NULL,
      '03024410',
      '10402204',
      '24213330',
      '43441111',
      '21231444',
      '01431202',
      '03211340',
      NULL,
      '43210222',
      '11210441',
      NULL,
      '30101131',
      '12432231',
      '02131233',
      '30011123',
      '10444114',
      '22002030',
      '12001103',
      '34214032',
      NULL,
      '33111320',
      '41342202',
      '10411404',
      '32244112',
      '43030131',
      '20323321',
      '43303043',
      '31243014',
      '42431302',
      '33303403',
      '34301410',
      '14114330',
      '30321133',
      '42320320',
      '40322414',
      '43214034',
      '41312020',
      '',
      '',
      NULL,
      NULL,
      '1323002',
      3.004984,
      0.600701,
      NULL,
      NULL,
      '002001',
      2,
      ' 4- 4-1980',
      ' 3- 3-1993',
      4,
      NULL,
      NULL,
      NULL,
      6.708189,
      13,
      30.933555,
      7.148835,
      NULL,
      NULL,
      23.529617,
      9.163865,
      23,
      11.905974,
      31,
      11.998374,
      6,
      2,
      29,
      10.670204,
      36,
      3.774763,
      4.303988,
      3,
      NULL,
      51,
      62,
      27.834030,
      13.358301,
      43.076935,
      112.691027,
      ' 3- 2-1994',
      16,
      2.437331,
      16.343771,
      0,
      134.166467,
      103,
      ' 6-16-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      25.349388,
      56.286440,
      2,
      6,
      8,
      2,
      4,
      9.852936,
      42,
      33.727942,
      ' 1- 9-1982',
      6.823385,
      0.220581,
      1.464361,
      NULL,
      22,
      1,
      2,
      '10- 0-1977',
      NULL,
      6.289777,
      ' 6- 5-1975',
      NULL,
      2.987909,
      2,
      10.994689,
      14,
      3,
      NULL,
      3,
      NULL,
      47.700739,
      1.875310,
      NULL,
      5.533401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 6-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      15.327947,
      NULL,
      NULL,
      4,
      73.297495,
      ' 3-11-1990',
      NULL,
      NULL,
      0,
      31.752288,
      ' 2- 1-1990',
      19,
      1.675258,
      157.866765,
      ' 1- 2-1998',
      NULL,
      NULL,
      NULL,
      52,
      NULL,
      NULL,
      NULL,
      33.669525,
      115.370276,
      NULL,
      40.292650,
      13,
      31.304044,
      NULL,
      42,
      1.571608,
      0.623042,
      131.657745,
      NULL,
      NULL,
      NULL,
      5.578576,
      NULL,
      154.171309,
      1,
      NULL,
      299.447912,
      40.857739,
      27,
      30.233141,
      0.358358,
      36,
      0,
      0,
      NULL,
      1.232358,
      NULL,
      NULL,
      50.074697,
      42,
      33.511729,
      12,
      35,
      12.446568,
      NULL,
      1,
      16.436358,
      1.678734,
      7,
      NULL,
      1.826244,
      0,
      50.756490,
      4.715724,
      34.036336,
      1,
      1.853575,
      37,
      19,
      NULL,
      NULL,
      41.756495,
      48,
      17,
      2,
      12,
      3.384307,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      9,
      ' 3- 8-1990',
      NULL,
      ' 0-27-1974',
      ' 6- 8-2000',
      NULL,
      ' 9- 6-1996',
      ' 4-25-1990',
      NULL);
commit;
end;
/


