set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9537645';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2011',
      '00232313',
      NULL,
      '34213213',
      '44031110',
      '12433213',
      '02343010',
      '44322043',
      '42143102',
      '43220124',
      NULL,
      NULL,
      NULL,
      '02444304',
      '03033220',
      '03101312',
      '33433223',
      '33322012',
      '44221341',
      '21130242',
      '23322130',
      NULL,
      NULL,
      NULL,
      '43434310',
      NULL,
      '14222304',
      '42223213',
      '02032011',
      '43103031',
      '40243213',
      '42013021',
      '03300312',
      '34333420',
      NULL,
      '01132220',
      '33202234',
      '01331010',
      NULL,
      '03130140',
      '24233024',
      '34121220',
      '13444130',
      '14130322',
      '04040221',
      '030',
      '20',
      NULL,
      NULL,
      '2121123',
      NULL,
      1.869407,
      0,
      NULL,
      '320020',
      1.732810,
      ' 9-27-2000',
      ' 3-27-2003',
      47,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.080561,
      1.755414,
      NULL,
      NULL,
      0,
      7.384397,
      1,
      1,
      NULL,
      6,
      NULL,
      0,
      3,
      NULL,
      2.683169,
      3.887484,
      1.951816,
      2,
      1.022752,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-28-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      25,
      1,
      5,
      48,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-20-2002',
      2.788511,
      24.281718,
      NULL,
      46.182002,
      29.469378,
      23.452595,
      13.315173,
      NULL,
      56.976262,
      49,
      30.846889,
      25.336539,
      NULL,
      4,
      10,
      1,
      30.304184,
      NULL,
      0,
      5,
      ' 6-23-1976',
      4.032377,
      7,
      '11- 3-1996',
      2.961265,
      0,
      0.636703,
      7,
      9.197163,
      9.521117,
      1,
      6.463413,
      1.252573,
      50,
      3.477700,
      1,
      12,
      NULL,
      1.662448,
      3.822026,
      0,
      1.183433,
      ' 9- 8-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      75,
      ' 9-29-1994',
      NULL,
      NULL,
      NULL,
      27.769923,
      NULL,
      30.493634,
      ' 4-23-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      18,
      NULL,
      12,
      4.453002,
      19,
      ' 5- 2-1983',
      12.024226,
      232,
      ' 5-12-1995',
      5,
      NULL,
      NULL,
      15,
      '10-16-1980',
      51,
      1.318906,
      55.419249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


