set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9537645';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      '0',
      '2',
      '4',
      '0',
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      '0',
      '3',
      '3',
      NULL,
      '1',
      '2',
      NULL,
      '2',
      '4',
      NULL,
      '2',
      '3',
      '0',
      '',
      '4',
      '',
      '2',
      '2',
      '2',
      '0',
      '1',
      '',
      '',
      '0',
      '3',
      '0',
      NULL,
      '1',
      '0',
      NULL,
      '1',
      NULL,
      '4',
      '0',
      '040',
      NULL,
      55,
      37.655605,
      NULL,
      3.869047,
      NULL,
      1,
      NULL,
      '243130',
      NULL,
      ' 7-26-1988',
      ' 7-19-2003',
      28,
      NULL,
      24.825788,
      7,
      2.746198,
      2.932344,
      31.862108,
      5.329723,
      6.553043,
      2.486176,
      1.589688,
      NULL,
      NULL,
      10.257004,
      11,
      3.625703,
      2,
      15.876054,
      11.014701,
      6.450987,
      11.282621,
      3,
      89,
      2.343667,
      0,
      NULL,
      18,
      55,
      140,
      115,
      16,
      ' 8- 8-1992',
      37.530043,
      5.375384,
      20,
      7.518379,
      93,
      142.888695,
      ' 2-24-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36.412273,
      47,
      38.249751,
      30,
      NULL,
      2,
      '10- 1-1995',
      1.100980,
      1,
      31.363799,
      0.533567,
      0,
      94.449065,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-19-1976',
      35.606574,
      15.362508,
      45,
      0.427958,
      NULL,
      52.439983,
      NULL,
      38,
      67.550618,
      6.945663,
      33.139958,
      9,
      ' 2-29-1988',
      0,
      NULL,
      8,
      11.265960,
      17.370137,
      2,
      5,
      ' 5-13-1984',
      11.334584,
      11.403678,
      ' 0-28-1986',
      0,
      NULL,
      8.101615,
      6.102273,
      2.500335,
      NULL,
      NULL,
      5.522156,
      0,
      NULL,
      0,
      0,
      NULL,
      8,
      1.559188,
      1.614912,
      0.184799,
      0.444697,
      ' 0-22-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-12-1992',
      10,
      NULL,
      NULL,
      13.085462,
      ' 4- 3-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      ' 4-17-1992',
      NULL,
      NULL,
      NULL,
      ' 9-26-2001',
      0.890211,
      149.739620,
      ' 2-25-1977',
      0,
      50.119139,
      3.501484,
      118.620198,
      ' 0- 8-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


