set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9301594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1402',
      '42403032',
      NULL,
      '23120323',
      '42433000',
      '13104034',
      '11131304',
      '40242032',
      '32023304',
      '10312430',
      NULL,
      '31342400',
      '11100334',
      NULL,
      NULL,
      NULL,
      '41433004',
      '03042222',
      '03412404',
      '21234334',
      '31422331',
      '00234002',
      '31013402',
      '44410420',
      '24113013',
      '00302020',
      '22012411',
      '42144412',
      '10312111',
      '40202024',
      '13131303',
      NULL,
      '04444231',
      '20132103',
      '32232330',
      '42201210',
      '33322204',
      '24232400',
      '23002311',
      '31020303',
      '10213323',
      NULL,
      NULL,
      '32133314',
      '01402341',
      '243',
      '11',
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      5,
      ' 7- 0-2003',
      ' 3-17-1983',
      24.426945,
      NULL,
      3.093349,
      31,
      31.046916,
      7.207239,
      22.853271,
      8.376413,
      NULL,
      23.388416,
      47,
      NULL,
      NULL,
      17.530521,
      4,
      NULL,
      36,
      30.601779,
      40.919372,
      NULL,
      42.240574,
      27.878088,
      69,
      2.243975,
      1.684769,
      91,
      126,
      1.081699,
      207.470019,
      96.606913,
      NULL,
      '11- 4-2002',
      NULL,
      25,
      24.373234,
      33,
      135.779459,
      190,
      ' 3-27-1998',
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.950182,
      1.621003,
      0,
      NULL,
      NULL,
      0,
      0.989876,
      0.339411,
      NULL,
      NULL,
      1,
      1.506493,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-11-1987',
      28,
      0,
      NULL,
      NULL,
      NULL,
      5,
      ' 1-17-1997',
      0.596399,
      0,
      63,
      NULL,
      0,
      100.951557,
      NULL,
      NULL,
      44.556624,
      0.784447,
      0,
      NULL,
      ' 5-18-1985',
      116.730995,
      105.066305,
      5,
      35,
      32.173212,
      46.342432,
      40.556582,
      65.836120,
      113,
      15,
      36.596901,
      35.147425,
      ' 6-18-1988',
      6,
      NULL,
      20.787406,
      NULL,
      108.629791,
      45,
      15,
      ' 3-10-1979',
      6,
      22.247316,
      ' 5- 9-1981',
      9.454535,
      11.567246,
      11.278483,
      6,
      7,
      1,
      1,
      NULL,
      1.912016,
      136,
      0.767058,
      NULL,
      25.142856,
      21.964831,
      1,
      NULL,
      1.818608,
      0.585629,
      ' 9-10-1978',
      NULL,
      0.670778,
      3,
      NULL,
      NULL,
      14.679288,
      '11- 9-1982',
      61.586685,
      4.372997,
      NULL,
      NULL,
      NULL,
      13,
      ' 3-19-2002',
      2,
      14.148387,
      ' 6- 2-1999',
      40.905409,
      82,
      ' 6-28-1994',
      3.159502,
      4.113568,
      ' 1-28-1998',
      1,
      3.486628,
      NULL,
      0,
      2,
      11.683828,
      ' 1-11-2002',
      NULL,
      51,
      51,
      ' 8-12-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.882516);
commit;
end;
/


