set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530250';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '1',
      '2',
      '3',
      '1',
      '0',
      '2',
      NULL,
      '0',
      '3',
      '2',
      '2',
      '3',
      '2',
      '2',
      '4',
      '4',
      '4',
      NULL,
      '1',
      '0',
      '3',
      '0',
      '',
      '4',
      NULL,
      '2',
      '1',
      NULL,
      '0',
      NULL,
      '',
      NULL,
      '0',
      '3',
      '0',
      '1',
      '0',
      '0',
      '1',
      '2',
      '2',
      '1',
      '0',
      '143',
      '34242324',
      52,
      NULL,
      '2121242',
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      ' 2- 8-1994',
      '10- 6-1983',
      NULL,
      186.113729,
      NULL,
      7.310143,
      10,
      NULL,
      40,
      4,
      20,
      13,
      22,
      1,
      30.844493,
      2,
      25,
      NULL,
      NULL,
      6,
      11.983188,
      16.310151,
      33.616583,
      15,
      NULL,
      13,
      0.198219,
      37,
      92.895776,
      8.873474,
      108.907043,
      94.556234,
      NULL,
      NULL,
      27.865838,
      5.663495,
      NULL,
      2,
      62,
      0.725245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28.149748,
      5.898844,
      NULL,
      4,
      23.819919,
      0.932902,
      ' 9-23-2003',
      0.739204,
      1,
      151.441894,
      1,
      NULL,
      24.406735,
      1.361407,
      1,
      0.610298,
      NULL,
      NULL,
      NULL,
      ' 0-19-2002',
      63,
      22.461379,
      69.434057,
      49.719206,
      35,
      NULL,
      93,
      12,
      27.298575,
      71,
      77.953282,
      83,
      ' 8-13-2001',
      NULL,
      21,
      16,
      60,
      NULL,
      48.198137,
      NULL,
      NULL,
      6,
      13,
      NULL,
      13.636654,
      12,
      6,
      NULL,
      13.926891,
      NULL,
      NULL,
      0,
      1,
      45.434803,
      0,
      0,
      0,
      0.882138,
      6,
      3.562661,
      NULL,
      1,
      '11- 8-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      10.511170,
      46.568391,
      '10- 4-1999',
      NULL,
      NULL,
      NULL,
      33.031382,
      ' 8-10-1980',
      NULL,
      NULL,
      7.013511,
      9.434487,
      '11-25-1997',
      7.062877,
      12,
      ' 3-28-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.290039,
      ' 4- 1-1985',
      NULL,
      15,
      21.517990,
      NULL,
      0.203314,
      18,
      ' 9-28-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


