set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8430555';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1023',
      '13041433',
      '21324440',
      NULL,
      NULL,
      '43244424',
      '20021332',
      '10203234',
      '23342130',
      '24443442',
      NULL,
      '43040124',
      '03412431',
      '02012433',
      '43333040',
      '33324014',
      '43320223',
      '22320322',
      '20221324',
      '12200421',
      '21113223',
      '20433123',
      '13320002',
      '41120342',
      '12344122',
      '04201044',
      '23430300',
      '21312434',
      '20343031',
      '03340443',
      '21224023',
      '24203404',
      '32423302',
      '21332030',
      '33040202',
      '12041420',
      '21321421',
      '40133110',
      '24324212',
      '34244000',
      NULL,
      NULL,
      '11224104',
      '32104303',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '1012400',
      0.129708,
      0,
      2,
      NULL,
      '304110',
      2.238832,
      ' 1- 4-2001',
      ' 3- 0-2000',
      65,
      NULL,
      NULL,
      1.968097,
      29.126664,
      9,
      31,
      NULL,
      9,
      2.490936,
      4,
      11.107275,
      22,
      NULL,
      15.545018,
      3,
      4.613701,
      7.816770,
      NULL,
      4.690602,
      13.859682,
      12,
      53.878275,
      4,
      NULL,
      NULL,
      120.228746,
      14,
      51,
      71,
      3,
      NULL,
      31.520808,
      21,
      17,
      22.125234,
      58.297928,
      28.126070,
      ' 5- 9-1977',
      2,
      6.350967,
      2.159892,
      1.824255,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853166,
      0,
      7.610690,
      1,
      1.875784,
      0.980622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 6-1974',
      NULL,
      16.728013,
      17,
      48,
      12,
      72,
      67,
      54,
      48.313524,
      41,
      7,
      53,
      ' 4- 8-2001',
      NULL,
      9.477978,
      11.330047,
      NULL,
      42.035472,
      66,
      6,
      '11-11-1974',
      12,
      22,
      '11-11-1974',
      1.267021,
      NULL,
      NULL,
      14.948634,
      7,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      1.612635,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-20-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53.536021,
      29,
      25.334553,
      ' 1-23-1976',
      0,
      82,
      ' 1- 8-1981',
      5.855170,
      40.198610,
      1,
      63.787075,
      ' 6-16-1985',
      41.212314,
      0,
      92.069027,
      '11-16-1976',
      NULL,
      NULL,
      NULL,
      57,
      89.257412,
      1.340885,
      37,
      38,
      46.724383,
      116,
      22,
      31,
      36.936952,
      0.033556,
      NULL,
      NULL,
      4,
      30,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      115.308749,
      0.685061,
      3.184530,
      133,
      47,
      17,
      70,
      NULL,
      62.055612,
      1,
      0.529128,
      0.459445,
      1.203072,
      1,
      0.403180,
      NULL,
      NULL,
      70.559355,
      9,
      64,
      60.592441,
      0,
      1,
      8.864247,
      0,
      1.945020,
      NULL,
      7.543443,
      0.733198,
      17.541182,
      1,
      64.074318,
      2,
      1.500242,
      64.419768,
      19.155276,
      15,
      15,
      56,
      51,
      6,
      41,
      NULL,
      1.095393,
      0,
      4,
      NULL,
      3.425506,
      1,
      NULL,
      20,
      NULL,
      ' 3- 6-1986',
      ' 1-17-1999',
      ' 2- 2-1986',
      ' 0-19-1998',
      NULL,
      ' 3-10-1986',
      NULL);
commit;
end;
/


