set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9884735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '4',
      '2',
      '3',
      NULL,
      '4',
      '4',
      '2',
      NULL,
      '4',
      NULL,
      '4',
      '2',
      '4',
      '2',
      '0',
      '0',
      '3',
      '1',
      NULL,
      '3',
      '4',
      '0',
      '',
      '4',
      '',
      '4',
      '2',
      '2',
      '2',
      NULL,
      '',
      '',
      NULL,
      '0',
      '1',
      '2',
      '1',
      '4',
      '1',
      NULL,
      '3',
      '4',
      '4',
      '112',
      '04413231',
      39.817947,
      7,
      '2111132',
      2.239851,
      1.174839,
      2,
      1,
      '232233',
      0.429981,
      '10-10-1994',
      NULL,
      21.544477,
      55.728753,
      0.758191,
      8,
      NULL,
      NULL,
      6,
      2.135897,
      19.015779,
      9,
      14.577701,
      4.116275,
      NULL,
      9.298345,
      0,
      10,
      4,
      1,
      31,
      6.898877,
      22.303330,
      13,
      82.284342,
      NULL,
      1.140500,
      87,
      71,
      NULL,
      119.158137,
      NULL,
      99.154584,
      NULL,
      47.085861,
      54,
      28,
      3,
      93,
      171.019516,
      ' 4- 2-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      1.684501,
      41,
      4,
      0.496238,
      NULL,
      1.686349,
      0.086115,
      51,
      1.299719,
      NULL,
      NULL,
      0.843127,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-27-1998',
      88.987869,
      NULL,
      31.136133,
      86.759376,
      15,
      43,
      34.420427,
      NULL,
      61.328969,
      33.978251,
      NULL,
      46.705123,
      ' 7- 1-1977',
      20.173181,
      16.491494,
      5,
      NULL,
      NULL,
      27,
      NULL,
      NULL,
      12.460626,
      1.954139,
      ' 7- 0-1974',
      12.644531,
      12,
      NULL,
      21.349835,
      16.266888,
      4,
      1.922907,
      21.429154,
      0,
      47.617935,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      1,
      1.784907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      6.698104,
      ' 8-26-1992',
      0,
      NULL,
      10.466764,
      1.220859,
      NULL,
      110,
      43,
      '10- 9-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      ' 7- 5-1982',
      NULL,
      62.906614,
      NULL,
      NULL,
      1.133666,
      4,
      ' 1-21-2003',
      12,
      2.029356,
      23.992329,
      10,
      NULL,
      15,
      0.819332,
      54,
      ' 0-14-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


