set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9884735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      '2',
      '0',
      '1',
      '2',
      '4',
      '1',
      '0',
      '1',
      '0',
      '3',
      '4',
      '2',
      '1',
      '2',
      NULL,
      '4',
      '1',
      '4',
      '3',
      NULL,
      '4',
      '',
      '2',
      NULL,
      '2',
      '1',
      '4',
      '3',
      '4',
      '',
      '',
      '2',
      '1',
      '1',
      '0',
      '0',
      NULL,
      '3',
      '4',
      NULL,
      '1',
      NULL,
      '233',
      '01424414',
      4,
      31,
      '4320043',
      5,
      1,
      2,
      NULL,
      '211313',
      1.913993,
      ' 2-19-1983',
      ' 1-29-1977',
      27.515531,
      135.563884,
      15,
      NULL,
      17.860421,
      20,
      NULL,
      NULL,
      7,
      4.025959,
      NULL,
      13,
      23,
      14.630348,
      14,
      8,
      22.052077,
      4.729096,
      41.409597,
      7,
      2.872824,
      12,
      48.764519,
      11.260840,
      NULL,
      51,
      6.979190,
      39.191242,
      71,
      131.253196,
      131,
      NULL,
      22,
      26,
      NULL,
      21,
      32.108562,
      159.327956,
      '11- 9-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.451179,
      36.653776,
      68,
      1,
      NULL,
      1,
      ' 2-25-1990',
      1,
      NULL,
      NULL,
      NULL,
      1.344015,
      64.082992,
      1.469799,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.826777,
      NULL,
      56,
      2,
      NULL,
      60,
      116,
      50,
      117,
      68,
      12.522862,
      NULL,
      ' 8-29-1995',
      NULL,
      0.440754,
      NULL,
      61,
      28.328612,
      27.323035,
      6.290964,
      ' 7-26-1996',
      NULL,
      3.362069,
      ' 7- 2-1978',
      10.896779,
      11,
      4.445315,
      NULL,
      6,
      1,
      0,
      16.036014,
      0,
      9,
      7.815414,
      NULL,
      9.783862,
      27.809518,
      NULL,
      0.988458,
      1,
      0,
      ' 4-10-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      86,
      68,
      ' 6-10-2001',
      NULL,
      NULL,
      NULL,
      35.395797,
      '10-29-2001',
      NULL,
      ' 9-28-1981',
      NULL,
      2.306903,
      ' 0- 7-1993',
      139.650725,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      5,
      ' 3-12-1996',
      20.997156,
      32.716100,
      40,
      ' 1-13-1996',
      0,
      45.472888,
      ' 6-27-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


