set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9616418';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2231',
      '14112302',
      '42012410',
      '13320030',
      NULL,
      '14420322',
      '13134412',
      '01142313',
      '44442422',
      NULL,
      '01302430',
      '11410312',
      '44331010',
      '44131414',
      '04144422',
      '12240332',
      '11024112',
      '03204101',
      '12340242',
      '00404224',
      '23331404',
      '10243014',
      '14241112',
      NULL,
      '11341334',
      '02412002',
      NULL,
      '10221032',
      '14043004',
      NULL,
      '31020010',
      '30141121',
      '44444143',
      '21410214',
      NULL,
      '23332321',
      '02011412',
      '21330142',
      '44113303',
      '31131204',
      '21224320',
      '41133242',
      '21412113',
      '31144431',
      '11342412',
      '320',
      '14',
      22.567606,
      11,
      '0100144',
      1.086099,
      0,
      NULL,
      NULL,
      '323241',
      4,
      ' 8-19-1984',
      ' 3-29-1977',
      135.471416,
      NULL,
      51.804361,
      NULL,
      19.865917,
      6.519181,
      102,
      15.241996,
      NULL,
      8.299073,
      NULL,
      NULL,
      6,
      18.071226,
      37,
      2,
      6,
      6,
      36.041146,
      14.248797,
      44.629852,
      11.664411,
      62.384839,
      NULL,
      1.354489,
      69.795792,
      109,
      120,
      205.728201,
      28,
      188,
      NULL,
      7.746060,
      41.665678,
      36.701182,
      24.541944,
      25,
      49.356076,
      ' 2-26-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      17,
      4.572306,
      NULL,
      NULL,
      NULL,
      ' 4-26-1982',
      1.369347,
      0,
      43,
      0,
      1,
      39,
      1.680966,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 2-1991',
      14,
      107.036862,
      82.501145,
      84.222275,
      4,
      57,
      20.012571,
      64,
      76,
      NULL,
      14,
      2.949361,
      ' 3-25-1978',
      8,
      12.361188,
      13.347759,
      2.464034,
      39.706652,
      38.692815,
      11,
      ' 6-12-1988',
      NULL,
      7.529104,
      ' 3-15-1987',
      8.556943,
      4,
      8.784471,
      17.922578,
      9.473072,
      0,
      0.651999,
      17,
      0,
      99.801122,
      NULL,
      NULL,
      14.127482,
      4,
      NULL,
      0,
      6,
      1.383010,
      '11- 7-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      245.922600,
      1,
      ' 8- 6-1998',
      NULL,
      NULL,
      NULL,
      26,
      ' 3-13-1983',
      3,
      ' 5- 3-2002',
      0,
      6.732449,
      NULL,
      123,
      18,
      ' 7- 2-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      18,
      ' 4-29-2003',
      34.804922,
      27.647507,
      40.571741,
      ' 5-11-1992',
      1.356289,
      25.758497,
      ' 0-11-1981',
      8,
      23.982918,
      0.993252,
      NULL,
      ' 2- 5-1990',
      46.127086,
      NULL,
      47.609918,
      ' 7-20-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


