set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9616418';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1433',
      '04240101',
      '03003144',
      '24302300',
      '04334313',
      '02024124',
      '03401423',
      '01310202',
      '04102440',
      NULL,
      NULL,
      NULL,
      '21414202',
      '11433441',
      '44323301',
      '41142114',
      '23112204',
      '10104400',
      '41331334',
      '03020440',
      '30200240',
      '03333130',
      NULL,
      '12113411',
      '32312130',
      '44433313',
      '34441322',
      NULL,
      '34214031',
      NULL,
      '03310413',
      '14010134',
      '12343413',
      NULL,
      '24044243',
      '43112113',
      '40110121',
      '30411440',
      '24231412',
      '01123140',
      '30014214',
      '21334233',
      '00041014',
      '30441214',
      '30424333',
      '313',
      '01',
      NULL,
      18,
      NULL,
      2,
      46.081485,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      ' 6-20-1994',
      81,
      65,
      29.972280,
      10,
      NULL,
      23,
      91,
      8.101115,
      26,
      NULL,
      11.202690,
      10.582196,
      16.800485,
      13,
      4.312737,
      21.166064,
      39,
      14.176055,
      85,
      9.957133,
      5,
      18,
      NULL,
      NULL,
      1,
      NULL,
      11.271157,
      117,
      131,
      170.255013,
      192.868295,
      ' 8-14-1991',
      49,
      55.575366,
      10.172085,
      10,
      NULL,
      115.553527,
      ' 6- 8-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.343165,
      NULL,
      NULL,
      11,
      NULL,
      3,
      ' 6-28-1982',
      0,
      NULL,
      53.657398,
      0,
      0,
      29,
      0.824060,
      3.576716,
      56,
      NULL,
      NULL,
      NULL,
      ' 8-24-1981',
      93,
      48.647912,
      NULL,
      64,
      2.404805,
      11.265431,
      NULL,
      5.330677,
      76,
      63.485862,
      67.856380,
      85.965360,
      NULL,
      22.232620,
      13,
      6.729831,
      62,
      59,
      36.553274,
      11,
      ' 0-11-1993',
      17,
      19.882169,
      NULL,
      3.459611,
      NULL,
      13.206318,
      NULL,
      NULL,
      4.455316,
      NULL,
      1.383789,
      NULL,
      11.798325,
      0,
      1.503221,
      4.480657,
      5,
      2,
      0,
      0.062268,
      NULL,
      ' 1-23-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      142,
      1,
      ' 2- 8-1988',
      NULL,
      NULL,
      NULL,
      0,
      ' 8-17-1981',
      4.865036,
      ' 3-24-2001',
      17.153016,
      0,
      ' 1-19-1981',
      15,
      80.770930,
      '10-17-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.220996,
      ' 5-27-1998',
      71.953599,
      14.937984,
      19,
      NULL,
      0,
      37.448230,
      ' 7- 4-2001',
      16.750609,
      22,
      18.072703,
      27,
      ' 8- 0-1988',
      18,
      1.361033,
      122,
      ' 4-18-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


