set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9616418';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '4',
      '0',
      '0',
      '4',
      '3',
      NULL,
      '2',
      NULL,
      '1',
      '4',
      '2',
      '3',
      '0',
      '2',
      '4',
      '2',
      '0',
      '0',
      '0',
      '2',
      NULL,
      NULL,
      '',
      '4',
      '',
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '1',
      '2',
      '4',
      '3',
      '2',
      '2',
      '1',
      NULL,
      NULL,
      '3',
      NULL,
      '213',
      NULL,
      5.450348,
      1,
      '1122312',
      1.836905,
      115.249230,
      2,
      NULL,
      NULL,
      5.645938,
      ' 7-17-1974',
      ' 4-18-1995',
      25,
      NULL,
      NULL,
      14.295714,
      9.622643,
      NULL,
      37.654501,
      NULL,
      9,
      5.283487,
      18,
      6.596069,
      41,
      10,
      17.741869,
      NULL,
      26.923820,
      15.754135,
      117,
      2.451886,
      3.241553,
      8,
      81,
      16,
      NULL,
      113.024407,
      69.709623,
      NULL,
      164.577660,
      101,
      174.504710,
      ' 4- 4-2003',
      25.360013,
      2.871025,
      23.997721,
      21.110512,
      93,
      62,
      ' 1- 4-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32,
      NULL,
      0.564086,
      3.535227,
      9.844618,
      5,
      ' 6-18-1985',
      1.686903,
      1.438724,
      98.803317,
      NULL,
      3.862984,
      NULL,
      0.054359,
      1.073718,
      75.173238,
      NULL,
      NULL,
      NULL,
      ' 6-13-1993',
      107,
      NULL,
      69,
      87.732763,
      116,
      107.381082,
      117,
      54.163672,
      10,
      38,
      67,
      40.926824,
      NULL,
      26.148082,
      22.196070,
      22.507933,
      46,
      36,
      79,
      1,
      ' 4-23-1993',
      16,
      5.967981,
      ' 3-20-1981',
      3.632922,
      2,
      7.348832,
      4.815556,
      7,
      NULL,
      1,
      0.452496,
      1,
      58,
      0.443101,
      NULL,
      3,
      29,
      1,
      1.029916,
      1.252724,
      0,
      ' 9-17-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      171.140739,
      1.884165,
      ' 0- 7-1980',
      NULL,
      NULL,
      NULL,
      54.452148,
      ' 8- 9-1978',
      30.709936,
      ' 5- 5-1995',
      6.920327,
      NULL,
      '10-17-1984',
      NULL,
      146.935089,
      ' 7-25-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9,
      ' 6- 6-1991',
      62.402184,
      13.286283,
      49,
      NULL,
      1.504958,
      NULL,
      ' 5-29-1989',
      15,
      27.410352,
      NULL,
      NULL,
      ' 3-20-1981',
      55.537795,
      0.697201,
      123.411757,
      ' 1-24-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


