set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9616418';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      '2',
      '4',
      '4',
      '3',
      NULL,
      '4',
      '3',
      '2',
      NULL,
      NULL,
      '3',
      '1',
      '3',
      '1',
      '3',
      NULL,
      '4',
      '3',
      NULL,
      '4',
      '3',
      '',
      '3',
      NULL,
      '1',
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      '',
      '2',
      '1',
      '0',
      '4',
      '4',
      '3',
      '3',
      '3',
      '1',
      '4',
      '0',
      NULL,
      '10032442',
      29.276235,
      25,
      '3231410',
      1,
      188,
      3,
      1,
      '301044',
      5,
      NULL,
      ' 2-10-1983',
      36,
      281.166653,
      51,
      24.595461,
      15.530772,
      8.415410,
      38.585812,
      19.909813,
      17.293337,
      10.336766,
      NULL,
      10,
      39,
      11.610569,
      22.253468,
      11,
      40.157866,
      4,
      NULL,
      24,
      54,
      23.055809,
      96,
      0.893474,
      1,
      141,
      130,
      27,
      NULL,
      158,
      225,
      NULL,
      NULL,
      13,
      39.112490,
      4,
      183,
      NULL,
      '11-13-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      1.911157,
      0.077524,
      6.861653,
      3,
      ' 4-29-1986',
      1.403058,
      NULL,
      30.441776,
      1.363101,
      NULL,
      72.743913,
      1.971197,
      1.975531,
      45,
      NULL,
      NULL,
      NULL,
      ' 0-24-1975',
      30.298935,
      109.863019,
      108.930102,
      40,
      16.572549,
      16.615231,
      NULL,
      NULL,
      88,
      76,
      85,
      18.138970,
      ' 7- 6-2002',
      13.884083,
      NULL,
      8,
      54,
      63.297137,
      174,
      7.418584,
      ' 8- 5-1975',
      1.502671,
      NULL,
      ' 7-23-1998',
      1.699323,
      NULL,
      9,
      2.098218,
      9,
      5.164979,
      0.621063,
      10,
      0.347174,
      9.227852,
      0.986445,
      1.224405,
      8.655172,
      9.426098,
      1.905276,
      5.720124,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      202,
      NULL,
      ' 0-19-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-25-2001',
      21.222315,
      '11-10-1974',
      15.041200,
      15.474403,
      ' 4-24-2003',
      105.337655,
      NULL,
      ' 5-22-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      11.971094,
      NULL,
      4.977054,
      19,
      12.217938,
      ' 1- 9-2000',
      NULL,
      29.414958,
      '10-18-1981',
      12,
      18.773686,
      20,
      21,
      ' 7-12-1996',
      37.693630,
      0.222285,
      122,
      ' 7-10-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


