set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3132',
      '23422240',
      '21111244',
      '14223133',
      '42220211',
      '01234324',
      '33411232',
      '44041113',
      '40101243',
      '04413004',
      '30304031',
      '24342100',
      '42431310',
      '33244243',
      '20033242',
      '33041032',
      '43421141',
      '42101434',
      '20401140',
      '43131323',
      '23040332',
      '41441141',
      NULL,
      '22400124',
      '34403430',
      '44032342',
      '01224213',
      '34231042',
      NULL,
      '12140210',
      '10042400',
      NULL,
      '31140340',
      '03420011',
      '03443020',
      '01244010',
      '13032344',
      '11430321',
      NULL,
      '23332332',
      '22144404',
      '23011302',
      '22124100',
      '01334010',
      '13141321',
      '',
      NULL,
      NULL,
      NULL,
      '0333143',
      2.022021,
      1,
      2,
      NULL,
      '323414',
      2.822638,
      '10-11-1998',
      NULL,
      38.929152,
      NULL,
      29,
      3.608364,
      27.030268,
      9,
      80,
      10.865452,
      0,
      20,
      4.026892,
      14.949236,
      25,
      2,
      5.426838,
      20,
      20,
      9,
      9,
      21,
      52,
      NULL,
      14,
      NULL,
      NULL,
      73,
      114,
      83.366548,
      126,
      166,
      41.077418,
      ' 2-16-1981',
      24.561262,
      6,
      22.789078,
      1.050740,
      91,
      20,
      ' 6- 3-1985',
      1,
      0,
      1.110726,
      0.730813,
      NULL,
      NULL,
      NULL,
      NULL,
      1.465809,
      NULL,
      0,
      1.366842,
      1.618728,
      0.611038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-29-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-18-1979',
      97,
      4,
      NULL,
      49,
      NULL,
      NULL,
      54.464723,
      23.524353,
      29,
      93,
      61.520542,
      74,
      '11-14-1992',
      NULL,
      25.861301,
      NULL,
      4,
      66,
      NULL,
      4,
      ' 7-14-1986',
      NULL,
      5.947235,
      NULL,
      7,
      NULL,
      7,
      NULL,
      NULL,
      1.815105,
      NULL,
      13,
      NULL,
      81,
      0,
      8.215927,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 5-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      65,
      3.315142,
      2.862936,
      NULL,
      NULL,
      NULL,
      ' 0-16-2001',
      5.770027,
      205.567836,
      1,
      NULL,
      '11-10-1990',
      56,
      1.567850,
      NULL,
      ' 7- 5-1983',
      NULL,
      NULL,
      NULL,
      19.400946,
      1,
      1.146880,
      66.335472,
      NULL,
      NULL,
      1.897020,
      5,
      36,
      13,
      NULL,
      8,
      0,
      1.518797,
      NULL,
      1,
      3.112047,
      51,
      0,
      0,
      154.631206,
      NULL,
      4,
      274,
      48.500323,
      NULL,
      81,
      1,
      51,
      28,
      0,
      0,
      0.492010,
      1.528102,
      0,
      14,
      34.618626,
      22.717639,
      18,
      81,
      65,
      1.327418,
      NULL,
      7.922173,
      0.333754,
      0.163018,
      0.011496,
      18,
      0.836972,
      65.939869,
      0.429814,
      NULL,
      1.242656,
      0,
      13.234440,
      27,
      2,
      NULL,
      43,
      42,
      7,
      NULL,
      18,
      0,
      1.751485,
      NULL,
      0.430132,
      1,
      NULL,
      0.373068,
      NULL,
      '10-12-1981',
      ' 9-24-2000',
      '11-25-1979',
      ' 7- 1-1975',
      ' 9-19-1982',
      ' 2-17-1974',
      ' 5- 6-1975',
      NULL);
commit;
end;
/


