set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23411424',
      '11430121',
      '23434124',
      NULL,
      '21020220',
      '10122401',
      '31441203',
      NULL,
      '30410013',
      '23320243',
      '00013221',
      '24230113',
      '04220343',
      '14132023',
      '14140141',
      '42313032',
      '22342003',
      '10422412',
      '20342214',
      '41342213',
      '10132222',
      '41222143',
      '02403422',
      '41012404',
      '03342314',
      '42234403',
      NULL,
      '31122233',
      NULL,
      '12020223',
      '24232104',
      '00214140',
      '12243431',
      '04104134',
      '00110111',
      NULL,
      '00240304',
      '03132233',
      '02033244',
      NULL,
      '24020413',
      '33131134',
      '23142140',
      '32034141',
      '',
      '',
      NULL,
      NULL,
      '3213424',
      NULL,
      NULL,
      NULL,
      NULL,
      '120424',
      0.905932,
      ' 8-14-1986',
      ' 0- 6-1997',
      13.068479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41.493157,
      NULL,
      7.881676,
      193.597913,
      NULL,
      ' 0- 8-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-12-1981',
      2,
      69,
      16.521702,
      46.578664,
      49.560920,
      6.799775,
      4,
      58.854191,
      75.047821,
      49,
      48.569392,
      38.289914,
      ' 7-25-1996',
      NULL,
      19,
      5,
      25,
      60,
      47.951183,
      NULL,
      ' 8-29-1981',
      NULL,
      20.173968,
      ' 8-18-1984',
      NULL,
      1.721027,
      17,
      8,
      NULL,
      4,
      NULL,
      13,
      NULL,
      87.158633,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.909085,
      12.823660,
      ' 7-19-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.745828,
      69,
      1,
      1,
      16,
      0.311890,
      2.335385,
      97.856978,
      0,
      4,
      244.150275,
      60,
      NULL,
      NULL,
      1.327348,
      57.745544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66.712247,
      NULL,
      NULL,
      NULL,
      55,
      0,
      1,
      61,
      NULL,
      1,
      15.475430,
      10,
      0,
      12,
      NULL,
      41,
      1.989224,
      1,
      18,
      19.769384,
      20,
      8.921947,
      49,
      NULL,
      NULL,
      NULL,
      14.376386,
      NULL,
      1.053603,
      NULL,
      NULL,
      NULL,
      NULL,
      0.701028,
      79.940750,
      NULL,
      NULL,
      NULL,
      ' 0- 8-1979',
      ' 4-14-2002',
      NULL,
      NULL,
      NULL);
commit;
end;
/


