set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '24403322',
      '41431243',
      '34101340',
      NULL,
      '11420011',
      '21402312',
      NULL,
      NULL,
      '21113410',
      '24203112',
      '32424040',
      '20003043',
      '11421423',
      '04304004',
      NULL,
      '31431111',
      '20424011',
      NULL,
      '33321213',
      '31020242',
      '12240421',
      '42322321',
      NULL,
      '11213413',
      '32214200',
      '34211343',
      '20130041',
      '13004021',
      '43314020',
      NULL,
      '41040430',
      '24033034',
      '13334131',
      '00100143',
      NULL,
      NULL,
      '43241111',
      '31404342',
      '03133331',
      '01341343',
      '24041340',
      '12432014',
      '42122030',
      '112',
      '34',
      NULL,
      NULL,
      '2440044',
      NULL,
      54.428246,
      2,
      NULL,
      '003212',
      3,
      ' 4-15-1999',
      ' 2- 2-2002',
      38.341616,
      NULL,
      21,
      0.878437,
      13.282244,
      21.879190,
      119,
      22,
      16,
      NULL,
      2,
      2.842082,
      43,
      20,
      22,
      2,
      12,
      4.667014,
      69,
      19.260047,
      30.971334,
      NULL,
      NULL,
      0.008174,
      3.679227,
      NULL,
      NULL,
      NULL,
      94,
      NULL,
      111,
      ' 3- 2-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793338,
      3.747448,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.119182,
      NULL,
      3.574662,
      1.792151,
      1.373706,
      0.212621,
      0.331595,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-10-1977',
      NULL,
      3,
      10.414293,
      15.664224,
      11.432884,
      1.685246,
      ' 2-23-1985',
      NULL,
      0,
      128.472519,
      1,
      3,
      NULL,
      1.683310,
      3,
      43.800023,
      NULL,
      NULL,
      NULL,
      NULL,
      100,
      90,
      96.691757,
      4.069953,
      24,
      NULL,
      0.595747,
      59,
      60.323351,
      37,
      74,
      5,
      NULL,
      3,
      11.257425,
      25.663571,
      NULL,
      33.894297,
      107.472722,
      12.183627,
      NULL,
      10,
      15.880989,
      ' 6- 2-1998',
      1.709559,
      11.305997,
      NULL,
      1,
      NULL,
      1.017919,
      0.712622,
      0.698486,
      0.143831,
      69,
      0,
      1,
      11,
      26,
      0.652251,
      NULL,
      1,
      NULL,
      ' 5-14-1996',
      NULL,
      NULL,
      2.271897,
      '11-10-1980',
      181.789475,
      10,
      ' 1- 3-1984',
      NULL,
      NULL,
      NULL,
      53,
      '10-20-1987',
      NULL,
      ' 7-28-1987',
      15.925901,
      11,
      ' 4-24-1992',
      74.556136,
      32.951318,
      ' 3- 8-1982',
      3,
      1,
      ' 2-12-1990',
      8,
      NULL,
      '10-19-1994',
      2,
      1,
      0.194259,
      ' 1- 7-1979',
      61,
      1,
      1.884309,
      '11-17-1997',
      0,
      104.533781,
      ' 6- 4-1982',
      2,
      86.681045,
      1.376030,
      NULL,
      ' 5- 0-1997',
      65,
      1.568346,
      NULL,
      ' 2-19-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.286540);
commit;
end;
/


