set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03004130',
      '44033143',
      '12314003',
      '41024430',
      NULL,
      '43331321',
      '12032213',
      '24204122',
      '13133332',
      '30101101',
      '32423000',
      '01104424',
      '21310312',
      '41241014',
      '00110122',
      '03213142',
      NULL,
      NULL,
      '20112411',
      '44230302',
      '22213400',
      '01302233',
      '12333322',
      NULL,
      '34222011',
      NULL,
      '24130222',
      '31330400',
      '41110014',
      '01031243',
      '44423202',
      '44342311',
      '04002020',
      NULL,
      '44133033',
      '33240143',
      '24111014',
      '12240043',
      '41220324',
      '44123031',
      '24232103',
      '30414303',
      NULL,
      NULL,
      NULL,
      '41',
      NULL,
      12.067017,
      '1202104',
      1,
      124.257802,
      3,
      NULL,
      '223034',
      1.444933,
      ' 5- 8-1993',
      '10-17-2003',
      92.474121,
      127.044322,
      8,
      12.268376,
      28.754732,
      4,
      41,
      13.178387,
      4,
      10.604127,
      17,
      4,
      NULL,
      5.142923,
      14.846101,
      5.745808,
      NULL,
      NULL,
      46,
      14,
      3,
      5.297821,
      NULL,
      NULL,
      1.110641,
      39.687093,
      151.487712,
      34.257531,
      88,
      152.837580,
      127.790685,
      ' 9-17-1990',
      25,
      20.326295,
      16.545115,
      NULL,
      92,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      1.757016,
      5,
      1.374273,
      5,
      6.374927,
      ' 6-21-1984',
      0.955784,
      1,
      NULL,
      0,
      NULL,
      35,
      NULL,
      0.287331,
      33,
      NULL,
      NULL,
      NULL,
      ' 9-22-1997',
      1,
      40,
      92.276171,
      102,
      25,
      6.177100,
      100.980689,
      63,
      NULL,
      59,
      57.014122,
      5.868683,
      ' 2- 9-1977',
      26,
      NULL,
      19,
      24,
      72.787362,
      161,
      1,
      ' 6- 9-1983',
      2.878145,
      3.111494,
      NULL,
      0,
      NULL,
      7,
      13,
      NULL,
      NULL,
      0,
      2.975674,
      0.356808,
      41.323560,
      0.204220,
      0.498269,
      1.505322,
      10.965163,
      11.606970,
      0.321559,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      ' 4-15-1986',
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      33,
      '11- 1-2003',
      10,
      4.814907,
      ' 6-15-2001',
      46,
      113,
      ' 0-13-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      20,
      ' 2-17-2002',
      37,
      21.474972,
      NULL,
      ' 9-12-2000',
      0,
      61.470896,
      ' 1-17-1975',
      19,
      27,
      20.402964,
      5.292205,
      ' 6-18-1985',
      NULL,
      1.800136,
      73.848626,
      ' 8-18-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


