set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '4',
      '3',
      '0',
      '2',
      '1',
      '4',
      '4',
      '2',
      '1',
      '1',
      '0',
      '0',
      NULL,
      '2',
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      '4',
      '2',
      '2',
      '',
      '0',
      '',
      '1',
      '1',
      '1',
      '3',
      '0',
      NULL,
      '',
      '4',
      '4',
      '3',
      '0',
      '4',
      NULL,
      '2',
      '4',
      '0',
      '3',
      NULL,
      NULL,
      '14410142',
      17,
      18.770515,
      '3201444',
      1.470820,
      NULL,
      3,
      NULL,
      NULL,
      1,
      '11- 8-1987',
      ' 3-21-1983',
      24,
      193.398289,
      23.705289,
      1,
      16.752120,
      NULL,
      NULL,
      13.056495,
      2.561355,
      13,
      NULL,
      10.014088,
      16,
      10,
      7,
      18.198516,
      6.301182,
      15,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      2.486558,
      1.890394,
      24,
      NULL,
      25.265558,
      18.395397,
      NULL,
      NULL,
      ' 1- 1-1988',
      55.062828,
      5,
      31,
      23,
      145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      108,
      7,
      4.146567,
      NULL,
      NULL,
      NULL,
      '10-23-2000',
      1,
      1,
      152.360272,
      0.049900,
      1.376751,
      40,
      1.889998,
      0.466963,
      51.202931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.780155,
      71,
      17,
      8.297885,
      NULL,
      48,
      3.026745,
      40,
      81,
      99,
      10.606133,
      ' 9-21-1980',
      22.160014,
      12.588781,
      4.866564,
      45,
      46.680316,
      149,
      NULL,
      ' 4-23-1975',
      6,
      2.100285,
      ' 2- 4-1988',
      NULL,
      6.955285,
      0.348438,
      10,
      2.437157,
      NULL,
      1.777608,
      3,
      0,
      36,
      1.699149,
      1,
      1.948020,
      2,
      10,
      2.549447,
      0.597038,
      0.238066,
      ' 6-26-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      51.676393,
      NULL,
      ' 2-21-1980',
      NULL,
      NULL,
      NULL,
      10,
      ' 5- 2-1989',
      6.805351,
      ' 0-28-1999',
      4.699153,
      10.225618,
      NULL,
      71.820502,
      110.546388,
      ' 1-10-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.263839,
      ' 8-15-1994',
      25.104018,
      21,
      17.001908,
      ' 0-22-1998',
      3.670640,
      76.121891,
      NULL,
      1,
      24,
      20,
      39,
      ' 8-16-1988',
      57,
      1.734421,
      46,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


