set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      '3',
      '3',
      '0',
      NULL,
      '1',
      '1',
      '2',
      '1',
      '0',
      '0',
      '1',
      '4',
      '0',
      '2',
      '4',
      '3',
      '1',
      '2',
      '2',
      '0',
      '3',
      '1',
      '',
      '3',
      '',
      '0',
      '4',
      '2',
      '0',
      '1',
      '',
      '',
      '1',
      '1',
      '2',
      '4',
      '4',
      NULL,
      '0',
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '13420113',
      24.926270,
      38,
      '4231112',
      NULL,
      33,
      0,
      1,
      '242432',
      2,
      ' 6- 0-1975',
      ' 0-20-1980',
      101,
      217,
      30.140683,
      2,
      5,
      5,
      36.727172,
      6.794453,
      6,
      13,
      0.933313,
      2,
      15.590580,
      13.789134,
      NULL,
      NULL,
      NULL,
      4.782830,
      13.252941,
      3.192394,
      47,
      10,
      NULL,
      NULL,
      1.201707,
      73.079736,
      183.761398,
      40,
      89.289877,
      147.437176,
      174,
      ' 0- 3-2001',
      22,
      48,
      10.231129,
      3,
      95,
      163.656146,
      '10-27-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.344798,
      NULL,
      NULL,
      7,
      12.464472,
      6.406612,
      ' 7-22-1988',
      0,
      NULL,
      185,
      0.643930,
      1.288413,
      2.134926,
      NULL,
      1.452530,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 2-1996',
      79.381572,
      99.187434,
      41,
      45.730727,
      67,
      18.812771,
      NULL,
      62.156747,
      NULL,
      95,
      104,
      34.152796,
      '10- 6-1996',
      9.434805,
      26.938310,
      13,
      3.013009,
      85.653933,
      NULL,
      0,
      '11-20-2000',
      10.318090,
      5.009290,
      ' 4-25-1982',
      11,
      NULL,
      7.085413,
      NULL,
      3,
      5.806800,
      0,
      3,
      0,
      40,
      0.832452,
      1,
      NULL,
      9,
      6.653712,
      4.336286,
      1,
      1.244104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 9-19-1983',
      NULL,
      NULL,
      NULL,
      30.559803,
      ' 9-24-1987',
      33.265007,
      NULL,
      3,
      7,
      ' 1- 1-1976',
      NULL,
      34.334111,
      '11- 6-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      6.916712,
      ' 4-28-1985',
      34.907574,
      17,
      2,
      ' 1-25-1982',
      1,
      51.214637,
      '11- 4-1998',
      12.816454,
      11.310513,
      NULL,
      NULL,
      ' 4-13-1997',
      6,
      1,
      81.939881,
      '11-14-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


