set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4143',
      '24220301',
      '22333120',
      NULL,
      '23404322',
      '33410434',
      NULL,
      '24322200',
      '44030101',
      '42021122',
      '43220204',
      '10232304',
      '04102314',
      '43202344',
      '11131440',
      '01302404',
      '32133311',
      '11410401',
      NULL,
      '30430041',
      NULL,
      '24414244',
      NULL,
      '34401013',
      '24104142',
      '12324044',
      '13340114',
      NULL,
      '44244443',
      '11202204',
      NULL,
      '41131303',
      '31002032',
      '32304444',
      '42413313',
      '00334340',
      '02301200',
      '33242313',
      NULL,
      NULL,
      '30140013',
      '30021204',
      '42223334',
      '03201203',
      '14421433',
      '023',
      '24',
      NULL,
      NULL,
      '1414210',
      3.798366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-16-1982',
      ' 9-11-2002',
      62,
      NULL,
      17,
      NULL,
      NULL,
      13.854718,
      33,
      8.007377,
      NULL,
      9.379243,
      13.312188,
      5.442082,
      4.168009,
      4.873309,
      NULL,
      7.117963,
      NULL,
      NULL,
      19.463033,
      2,
      42.268415,
      1,
      NULL,
      NULL,
      1.567550,
      17.723455,
      38,
      33.174052,
      87.301550,
      NULL,
      136.276595,
      ' 5-20-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.237196,
      0,
      3,
      1.595152,
      NULL,
      0,
      NULL,
      0.141213,
      0,
      0,
      1,
      0,
      1.880462,
      0.709212,
      NULL,
      29,
      1.706285,
      1.749993,
      6.520742,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 0-1983',
      16.565391,
      19,
      63,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.396664,
      10.078631,
      1.598876,
      NULL,
      58,
      1.403585,
      2.926032,
      31.823117,
      NULL,
      NULL,
      NULL,
      '10-24-1985',
      24,
      55,
      34,
      12.319416,
      NULL,
      41,
      72,
      80,
      78,
      39.139887,
      8,
      93.915709,
      '10- 7-1998',
      4.709091,
      NULL,
      3,
      44.111460,
      NULL,
      28.279061,
      11.500525,
      NULL,
      21,
      4,
      NULL,
      0.144271,
      9.976395,
      11.200674,
      6.264105,
      NULL,
      0,
      1,
      8,
      1.090579,
      22,
      8,
      NULL,
      6,
      3,
      NULL,
      8,
      NULL,
      2.799893,
      ' 6-10-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      82,
      ' 2-11-1994',
      NULL,
      NULL,
      NULL,
      43,
      ' 1- 3-1974',
      30,
      ' 8- 4-1977',
      10,
      0.023514,
      ' 3-24-1983',
      28.621002,
      84.197667,
      ' 6-28-1979',
      NULL,
      4.099385,
      ' 3-10-1999',
      NULL,
      NULL,
      NULL,
      2,
      2,
      7,
      ' 0-22-1984',
      6,
      6.839607,
      19,
      NULL,
      1.804256,
      192.998939,
      ' 6- 4-1984',
      1.136477,
      33,
      2,
      NULL,
      ' 4- 0-2001',
      NULL,
      NULL,
      139.515029,
      ' 0- 5-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


