set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0230',
      '03000021',
      '33123223',
      NULL,
      '14031422',
      '14430032',
      '24312211',
      NULL,
      '33140004',
      NULL,
      '12303010',
      '10204441',
      '22333122',
      '13021001',
      '24222200',
      '31140103',
      NULL,
      '03002241',
      '30222042',
      '01434303',
      NULL,
      '12434430',
      '31112234',
      '43143204',
      '00114414',
      '10020240',
      '23104220',
      '34410143',
      NULL,
      '34100333',
      '41424332',
      '04333103',
      '22211332',
      NULL,
      '40041033',
      NULL,
      '43312304',
      '21210141',
      '13021234',
      '31343233',
      '14403030',
      '11011404',
      NULL,
      NULL,
      '43411044',
      '232',
      '14',
      9.011321,
      12,
      NULL,
      0,
      NULL,
      3,
      NULL,
      '023111',
      2,
      ' 5- 1-2001',
      NULL,
      16.633690,
      14.748895,
      15,
      2.855122,
      1.270895,
      11,
      39.550077,
      9,
      6,
      NULL,
      19.388064,
      9.708391,
      3.507378,
      3.427532,
      30,
      0,
      3,
      3,
      NULL,
      10.485994,
      9,
      6,
      27,
      5.763142,
      NULL,
      NULL,
      29.864308,
      16,
      13.794850,
      111.474063,
      161.667437,
      ' 3-23-1983',
      43,
      3.112694,
      26.785356,
      15,
      82.536131,
      134,
      ' 4-19-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.866413,
      30.601087,
      NULL,
      3.761653,
      ' 6-16-1992',
      0.649210,
      0,
      106,
      NULL,
      4,
      64,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-18-1986',
      110,
      95.960620,
      96.376443,
      NULL,
      14,
      94,
      107,
      78.159506,
      NULL,
      NULL,
      40.078556,
      60,
      NULL,
      9.408117,
      NULL,
      19,
      NULL,
      33,
      4,
      10,
      ' 1-11-1994',
      9.235017,
      3.946143,
      ' 1-20-1976',
      6,
      10.474718,
      2.639508,
      2,
      4,
      7.177797,
      1.079429,
      6,
      17.270631,
      NULL,
      1.240510,
      2.904530,
      17.024853,
      1,
      5.533356,
      0.938832,
      0.641951,
      1.334072,
      ' 9-20-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 9-10-1977',
      NULL,
      NULL,
      NULL,
      0.790229,
      NULL,
      NULL,
      ' 0-20-2001',
      6,
      9.145573,
      NULL,
      89.782681,
      64,
      ' 8-19-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      4,
      ' 6-23-1985',
      24,
      37.352205,
      4,
      ' 3-19-1982',
      4,
      255,
      ' 2-18-2000',
      4,
      67,
      9.099413,
      121.948254,
      ' 0- 9-1976',
      27,
      1.398160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


